/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.accountnumberformat.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.accountnumberformat.data.AccountNumberFormatData;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatEnumerations;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.accountnumberformat.exception.AccountNumberFormatNotFoundException;
import org.apache.fineract.infrastructure.accountnumberformat.service.AccountNumberFormatReadPlatformService;
import org.apache.fineract.infrastructure.accountnumberformat.service.AccountNumberFormatReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class AccountNumberFormatReadPlatformServiceImpl
implements AccountNumberFormatReadPlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountNumberFormatReadPlatformServiceImpl.class);
    private final JdbcTemplate jdbcTemplate;
    private final AccountNumberFormatMapper accountNumberFormatMapper = new AccountNumberFormatMapper();

    public List<AccountNumberFormatData> getAllAccountNumberFormats() {
        String sql = "select " + this.accountNumberFormatMapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)this.accountNumberFormatMapper);
    }

    public AccountNumberFormatData getAccountNumberFormat(Long id) {
        try {
            String sql = "select " + this.accountNumberFormatMapper.schema() + " where anf.id = ?";
            AccountNumberFormatData accountNumberFormatData = (AccountNumberFormatData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.accountNumberFormatMapper, new Object[]{id});
            return accountNumberFormatData;
        }
        catch (EmptyResultDataAccessException e) {
            throw new AccountNumberFormatNotFoundException(id, e);
        }
    }

    public AccountNumberFormatData retrieveTemplate(EntityAccountType entityAccountTypeForTemplate) {
        List entityAccountTypeOptions = AccountNumberFormatEnumerations.entityAccountType((EntityAccountType[])EntityAccountType.values());
        HashMap accountNumberPrefixTypeOptions = new HashMap();
        if (entityAccountTypeForTemplate != null) {
            this.determinePrefixTypesForAccounts(accountNumberPrefixTypeOptions, entityAccountTypeForTemplate);
        } else {
            for (EntityAccountType entityAccountType : EntityAccountType.values()) {
                this.determinePrefixTypesForAccounts(accountNumberPrefixTypeOptions, entityAccountType);
            }
        }
        return new AccountNumberFormatData(entityAccountTypeOptions, accountNumberPrefixTypeOptions);
    }

    public void determinePrefixTypesForAccounts(Map<String, List<EnumOptionData>> accountNumberPrefixTypeOptions, EntityAccountType entityAccountType) {
        Set accountNumberPrefixTypesSet = new HashSet();
        switch (1.$SwitchMap$org$apache$fineract$infrastructure$accountnumberformat$domain$EntityAccountType[entityAccountType.ordinal()]) {
            case 1: {
                accountNumberPrefixTypesSet = AccountNumberFormatEnumerations.accountNumberPrefixesForClientAccounts;
                break;
            }
            case 2: {
                accountNumberPrefixTypesSet = AccountNumberFormatEnumerations.accountNumberPrefixesForLoanAccounts;
                break;
            }
            case 3: {
                accountNumberPrefixTypesSet = AccountNumberFormatEnumerations.accountNumberPrefixesForSavingsAccounts;
                break;
            }
            case 4: {
                accountNumberPrefixTypesSet = AccountNumberFormatEnumerations.accountNumberPrefixesForCenters;
                break;
            }
            case 5: {
                accountNumberPrefixTypesSet = AccountNumberFormatEnumerations.accountNumberPrefixesForGroups;
                break;
            }
        }
        Object[] array = accountNumberPrefixTypesSet.toArray();
        AccountNumberFormatEnumerations.AccountNumberPrefixType[] accountNumberPrefixTypes = (AccountNumberFormatEnumerations.AccountNumberPrefixType[])Arrays.copyOf(array, array.length, AccountNumberFormatEnumerations.AccountNumberPrefixType[].class);
        accountNumberPrefixTypeOptions.put(entityAccountType.getCode(), AccountNumberFormatEnumerations.accountNumberPrefixType((AccountNumberFormatEnumerations.AccountNumberPrefixType[])accountNumberPrefixTypes));
    }

    @Generated
    public AccountNumberFormatReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

