/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.data.LoanAccountStayedLockedData;
import org.apache.fineract.cob.data.LoanAccountsStayedLockedData;
import org.apache.fineract.cob.loan.LoanAccountsStayedLockedBusinessEvent;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class StayedLockedLoansTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StayedLockedLoansTasklet.class);
    private final BusinessEventNotifierService businessEventNotifierService;
    private final RetrieveLoanIdService retrieveLoanIdService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        LoanAccountsStayedLockedData lockedLoanAccounts = this.buildLoanAccountData();
        if (!lockedLoanAccounts.getLoanAccounts().isEmpty()) {
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAccountsStayedLockedBusinessEvent(lockedLoanAccounts));
        }
        return RepeatStatus.FINISHED;
    }

    private LoanAccountsStayedLockedData buildLoanAccountData() {
        LocalDate cobBusinessDate = ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE);
        List stayedLockedLoanAccounts = this.retrieveLoanIdService.findAllStayedLockedByCobBusinessDate(cobBusinessDate);
        ArrayList loanAccounts = new ArrayList();
        stayedLockedLoanAccounts.forEach(loanAccount -> loanAccounts.add(new LoanAccountStayedLockedData(loanAccount.getId(), loanAccount.getExternalId(), loanAccount.getAccountNo())));
        return new LoanAccountsStayedLockedData(loanAccounts);
    }

    @Generated
    public StayedLockedLoansTasklet(BusinessEventNotifierService businessEventNotifierService, RetrieveLoanIdService retrieveLoanIdService) {
        this.businessEventNotifierService = businessEventNotifierService;
        this.retrieveLoanIdService = retrieveLoanIdService;
    }
}

