/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.address.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.component.FetcherRule;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.address.data.AddressData;
import org.apache.fineract.portfolio.address.filter.ClientAddressSearchParam;
import org.apache.fineract.portfolio.address.service.AddressReadPlatformService;
import org.apache.fineract.portfolio.address.service.AddressReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class AddressReadPlatformServiceImpl
implements AddressReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final CodeValueReadPlatformService readService;

    public List<AddressData> retrieveAddressFields(long clientid) {
        this.context.authenticatedUser();
        AddFieldsMapper rm = new AddFieldsMapper();
        String sql = "select " + rm.schema() + " where client.id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid});
    }

    public List<AddressData> retrieveAllClientAddress(long clientid) {
        this.context.authenticatedUser();
        AddMapper rm = new AddMapper();
        String sql = "select " + rm.schema() + " and ca.client_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid});
    }

    public List<AddressData> retrieveAddressbyType(long clientid, long typeid) {
        this.context.authenticatedUser();
        AddMapper rm = new AddMapper();
        String sql = "select " + rm.schema() + " and ca.client_id=? and ca.address_type_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid, typeid});
    }

    public List<AddressData> retrieveAddressbyTypeAndStatus(long clientid, long typeid, String status) {
        this.context.authenticatedUser();
        boolean temp = Boolean.parseBoolean(status);
        AddMapper rm = new AddMapper();
        String sql = "select " + rm.schema() + " and ca.client_id=? and ca.address_type_id=? and ca.is_active=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid, typeid, temp});
    }

    public List<AddressData> retrieveAddressbyStatus(long clientid, String status) {
        this.context.authenticatedUser();
        boolean temp = Boolean.parseBoolean(status);
        AddMapper rm = new AddMapper();
        String sql = "select " + rm.schema() + " and ca.client_id=? and ca.is_active=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid, temp});
    }

    public List<AddressData> retrieveBySearchParam(ClientAddressSearchParam params) {
        return this.getFilterRules().stream().filter(rule -> rule.matches((Object)params)).map(r -> (List)r.execute((Object)params)).findFirst().orElse(this.retrieveAddressbyStatus(params.getClientId().longValue(), params.getStatus()));
    }

    public AddressData retrieveTemplate() {
        List countryoptions = this.readService.retrieveCodeValuesByCode("COUNTRY");
        List StateOptions = this.readService.retrieveCodeValuesByCode("STATE");
        List addressTypeOptions = this.readService.retrieveCodeValuesByCode("ADDRESS_TYPE");
        return AddressData.template((Collection)countryoptions, (Collection)StateOptions, (Collection)addressTypeOptions);
    }

    private List<FetcherRule<ClientAddressSearchParam, List<AddressData>>> getFilterRules() {
        return List.of(new FetcherRule(p -> p.getAddressTypeId() == 0L && p.getStatus() == null, p -> this.retrieveAllClientAddress(p.getClientId().longValue())), new FetcherRule(p -> p.getAddressTypeId() != 0L && p.getStatus() == null, p -> this.retrieveAddressbyType(p.getClientId().longValue(), p.getAddressTypeId().longValue())), new FetcherRule(p -> p.getAddressTypeId() != 0L && p.getStatus() != null, p -> this.retrieveAddressbyTypeAndStatus(p.getClientId().longValue(), p.getAddressTypeId().longValue(), p.getStatus())));
    }

    @Generated
    public AddressReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, CodeValueReadPlatformService readService) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.readService = readService;
    }
}

