/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.api;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.creditbureau.data.CreditReportData;
import org.apache.fineract.infrastructure.creditbureau.service.CreditReportReadPlatformService;
import org.apache.fineract.infrastructure.creditbureau.service.CreditReportWritePlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

@Path(value="/v1/creditBureauIntegration")
@Component
public class CreditBureauIntegrationApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "creditBureauId", "nrc", "creditReport"));
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<CreditReportData> toCreditReportApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final CreditReportWritePlatformService creditReportWritePlatformService;
    private final CreditReportReadPlatformService creditReportReadPlatformService;
    private final DefaultToApiJsonSerializer<CreditReportData> toApiJsonSerializer;
    private static final Logger LOG = LoggerFactory.getLogger(CreditBureauIntegrationApiResource.class);

    @POST
    @Path(value="creditReport")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequestBody(description="Fetch credit report", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))})
    public String fetchCreditReport(@Context UriInfo uriInfo, @RequestParam(value="params") Map<String, Object> params) {
        Gson gson = new Gson();
        String json = gson.toJson(params);
        CommandWrapper commandRequest = new CommandWrapperBuilder().getCreditReport().withJson(json).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toCreditReportApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="addCreditReport")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload credit report", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String addCreditReport(@FormDataParam(value="file") File creditReport, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") UriInfo uriInfo, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="creditBureauId") @Parameter(description="creditBureauId") Long creditBureauId) {
        String responseMessage = this.creditReportWritePlatformService.addCreditReport(creditBureauId, creditReport, fileDetail);
        return this.toCreditReportApiJsonSerializer.serialize((Object)responseMessage);
    }

    @POST
    @Path(value="saveCreditReport")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String saveCreditReport(@Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="creditBureauId") @Parameter(description="creditBureauId") Long creditBureauId, @QueryParam(value="nationalId") @Parameter(description="nationalId") String nationalId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().saveCreditReport(creditBureauId.longValue(), nationalId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toCreditReportApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="creditReport/{creditBureauId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getSavedCreditReport(@PathParam(value="creditBureauId") @Parameter(description="creditBureauId") Long creditBureauId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser();
        Collection creditReport = this.creditReportReadPlatformService.retrieveCreditReportDetails(creditBureauId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, creditReport, RESPONSE_DATA_PARAMETERS);
    }

    @DELETE
    @Path(value="deleteCreditReport/{creditBureauId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String deleteCreditReport(@PathParam(value="creditBureauId") @Parameter(description="creditBureauId") Long creditBureauId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCreditReport(creditBureauId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toCreditReportApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public CreditBureauIntegrationApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<CreditReportData> toCreditReportApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, CreditReportWritePlatformService creditReportWritePlatformService, CreditReportReadPlatformService creditReportReadPlatformService, DefaultToApiJsonSerializer<CreditReportData> toApiJsonSerializer) {
        this.context = context;
        this.toCreditReportApiJsonSerializer = toCreditReportApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.creditReportWritePlatformService = creditReportWritePlatformService;
        this.creditReportReadPlatformService = creditReportReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
    }
}

