/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.service;

import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.fineract.infrastructure.bulkimport.data.BulkImportEvent;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.data.ImportData;
import org.apache.fineract.infrastructure.bulkimport.domain.ImportDocument;
import org.apache.fineract.infrastructure.bulkimport.domain.ImportDocumentRepository;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookServiceImpl;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.documentmanagement.data.DocumentData;
import org.apache.fineract.infrastructure.documentmanagement.domain.Document;
import org.apache.fineract.infrastructure.documentmanagement.domain.DocumentRepository;
import org.apache.fineract.infrastructure.documentmanagement.service.DocumentWritePlatformService;
import org.apache.fineract.infrastructure.documentmanagement.service.DocumentWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class BulkImportWorkbookServiceImpl
implements BulkImportWorkbookService {
    private static final Logger LOG = LoggerFactory.getLogger(BulkImportWorkbookServiceImpl.class);
    private final ApplicationContext applicationContext;
    private final PlatformSecurityContext securityContext;
    private final DocumentWritePlatformService documentWritePlatformService;
    private final DocumentRepository documentRepository;
    private final ImportDocumentRepository importDocumentRepository;
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public BulkImportWorkbookServiceImpl(ApplicationContext applicationContext, PlatformSecurityContext securityContext, DocumentWritePlatformService documentWritePlatformService, DocumentRepository documentRepository, ImportDocumentRepository importDocumentRepository, JdbcTemplate jdbcTemplate) {
        this.applicationContext = applicationContext;
        this.securityContext = securityContext;
        this.documentWritePlatformService = documentWritePlatformService;
        this.documentRepository = documentRepository;
        this.importDocumentRepository = importDocumentRepository;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Long importWorkbook(String entity, InputStream inputStream, FormDataContentDisposition fileDetail, String locale, String dateFormat) {
        try {
            if (entity != null && inputStream != null && fileDetail != null && locale != null && dateFormat != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream clonedInputStream = new ByteArrayInputStream(bytes);
                BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
                Tika tika = new Tika();
                TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)bis);
                String fileType = tika.detect((InputStream)tikaInputStream);
                if (!fileType.contains("msoffice") && !fileType.contains("application/vnd.ms-excel")) {
                    throw new GeneralPlatformDomainRuleException("error.msg.invalid.file.extension", "Uploaded file extension is not recognized.", new Object[0]);
                }
                HSSFWorkbook workbook = new HSSFWorkbook((InputStream)clonedInputStream);
                GlobalEntityType entityType = null;
                int primaryColumn = 0;
                if (entity.trim().equalsIgnoreCase(GlobalEntityType.CLIENTS_PERSON.toString())) {
                    entityType = GlobalEntityType.CLIENTS_PERSON;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.CLIENTS_ENTITY.toString())) {
                    entityType = GlobalEntityType.CLIENTS_ENTITY;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.CENTERS.toString())) {
                    entityType = GlobalEntityType.CENTERS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.GROUPS.toString())) {
                    entityType = GlobalEntityType.GROUPS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.LOANS.toString())) {
                    entityType = GlobalEntityType.LOANS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.LOAN_TRANSACTIONS.toString())) {
                    entityType = GlobalEntityType.LOAN_TRANSACTIONS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.GUARANTORS.toString())) {
                    entityType = GlobalEntityType.GUARANTORS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.OFFICES.toString())) {
                    entityType = GlobalEntityType.OFFICES;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.CHART_OF_ACCOUNTS.toString())) {
                    entityType = GlobalEntityType.CHART_OF_ACCOUNTS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.GL_JOURNAL_ENTRIES.toString())) {
                    entityType = GlobalEntityType.GL_JOURNAL_ENTRIES;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.STAFF.toString())) {
                    entityType = GlobalEntityType.STAFF;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.SHARE_ACCOUNTS.toString())) {
                    entityType = GlobalEntityType.SHARE_ACCOUNTS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.SAVINGS_ACCOUNT.toString())) {
                    entityType = GlobalEntityType.SAVINGS_ACCOUNT;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.SAVINGS_TRANSACTIONS.toString())) {
                    entityType = GlobalEntityType.SAVINGS_TRANSACTIONS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS.toString())) {
                    entityType = GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS_TRANSACTIONS.toString())) {
                    entityType = GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS_TRANSACTIONS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.FIXED_DEPOSIT_ACCOUNTS.toString())) {
                    entityType = GlobalEntityType.FIXED_DEPOSIT_ACCOUNTS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.FIXED_DEPOSIT_TRANSACTIONS.toString())) {
                    entityType = GlobalEntityType.FIXED_DEPOSIT_TRANSACTIONS;
                    primaryColumn = 0;
                } else if (entity.trim().equalsIgnoreCase(GlobalEntityType.USERS.toString())) {
                    entityType = GlobalEntityType.USERS;
                    primaryColumn = 0;
                } else {
                    workbook.close();
                    throw new GeneralPlatformDomainRuleException("error.msg.unable.to.find.resource", "Unable to find requested resource", new Object[0]);
                }
                return this.publishEvent(Integer.valueOf(primaryColumn), fileDetail, (InputStream)bis, entityType, (Workbook)workbook, locale, dateFormat);
            }
            throw new GeneralPlatformDomainRuleException("error.msg.null", "One or more of the given parameters not found", new Object[0]);
        }
        catch (IOException e) {
            LOG.error("Problem occurred in importWorkbook function", (Throwable)e);
            throw new GeneralPlatformDomainRuleException("error.msg.io.exception", "IO exception occured with " + fileDetail.getFileName() + " " + e.getMessage(), new Object[]{e});
        }
    }

    private Long publishEvent(Integer primaryColumn, FormDataContentDisposition fileDetail, InputStream clonedInputStreamWorkbook, GlobalEntityType entityType, Workbook workbook, String locale, String dateFormat) {
        String fileName = fileDetail.getFileName();
        Long documentId = this.documentWritePlatformService.createInternalDocument(DocumentWritePlatformServiceJpaRepositoryImpl.DocumentManagementEntity.IMPORT.name(), (Long)this.securityContext.authenticatedUser().getId(), null, clonedInputStreamWorkbook, URLConnection.guessContentTypeFromName(fileName), fileName, null, fileName);
        Document document = this.documentRepository.findById((Object)documentId).orElse(null);
        ImportDocument importDocument = ImportDocument.instance((Document)document, (LocalDateTime)DateUtils.getLocalDateTimeOfTenant(), (Integer)entityType.getValue(), (AppUser)this.securityContext.authenticatedUser(), (Integer)ImportHandlerUtils.getNumberOfRows((Sheet)workbook.getSheetAt(0), (int)primaryColumn));
        this.importDocumentRepository.saveAndFlush((Object)importDocument);
        BulkImportEvent event = BulkImportEvent.instance((Object)this, (Workbook)workbook, (Long)((Long)importDocument.getId()), (String)locale, (String)dateFormat, (FineractContext)ThreadLocalContextUtil.getContext());
        this.applicationContext.publishEvent((ApplicationEvent)event);
        return (Long)importDocument.getId();
    }

    public Collection<ImportData> getImports(GlobalEntityType type) {
        this.securityContext.authenticatedUser();
        ImportMapper rm = new ImportMapper();
        String sql = "select " + rm.schema() + " order by i.id desc";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{type.getValue()});
    }

    public DocumentData getOutputTemplateLocation(String importDocumentId) {
        this.securityContext.authenticatedUser();
        ImportTemplateLocationMapper importTemplateLocationMapper = new ImportTemplateLocationMapper();
        String sql = "select " + importTemplateLocationMapper.schema();
        return (DocumentData)this.jdbcTemplate.queryForObject(sql, (RowMapper)importTemplateLocationMapper, new Object[]{Integer.parseInt(importDocumentId)});
    }

    public Response getOutputTemplate(String importDocumentId) {
        this.securityContext.authenticatedUser();
        ImportTemplateLocationMapper importTemplateLocationMapper = new ImportTemplateLocationMapper();
        String sql = "select " + importTemplateLocationMapper.schema();
        DocumentData documentData = (DocumentData)this.jdbcTemplate.queryForObject(sql, (RowMapper)importTemplateLocationMapper, new Object[]{importDocumentId});
        return this.buildResponse(documentData);
    }

    private Response buildResponse(DocumentData documentData) {
        String fileName = "Output" + documentData.getFileName();
        String fileLocation = documentData.getLocation();
        File file = new File(fileLocation);
        Response.ResponseBuilder response = Response.ok((Object)file);
        response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\""));
        response.header("Content-Type", (Object)"application/vnd.ms-excel");
        return response.build();
    }
}

