/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.sql.calcite.rule.logical;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;

public class LogicalUnnest extends Unnest
{
  protected LogicalUnnest(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexNode unnestExpr,
      RelDataTypeField unnestFieldType, RexNode condition)
  {
    super(cluster, traits, input, unnestExpr, unnestFieldType, condition);
  }

  @Override
  public RelNode copy(RelTraitSet traitSet, RelNode input)
  {
    return new LogicalUnnest(getCluster(), traitSet, input, unnestExpr, unnestFieldType, filter);
  }


  public LogicalUnnest copy(RelTraitSet traitSet, RelNode input, RexNode newUnnestExpr, RexNode newFilter)
  {
    return new LogicalUnnest(getCluster(), traitSet, input, newUnnestExpr, unnestFieldType, newFilter);
  }


}
