/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google.output;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.ExportStorageProvider;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.output.GoogleExportConfig;
import org.apache.druid.storage.google.output.GoogleOutputConfig;
import org.apache.druid.storage.google.output.GoogleStorageConnector;

@JsonTypeName(value="google")
public class GoogleExportStorageProvider
implements ExportStorageProvider {
    public static final String TYPE_NAME = "google";
    private static final String DELIM = "/";
    private static final Joiner JOINER = Joiner.on((String)"/").skipNulls();
    @JsonProperty
    private final String bucket;
    @JsonProperty
    private final String prefix;
    @JacksonInject
    GoogleExportConfig googleExportConfig;
    @JacksonInject
    GoogleStorage googleStorage;
    @JacksonInject
    GoogleInputDataConfig googleInputDataConfig;

    @JsonCreator
    public GoogleExportStorageProvider(@JsonProperty(value="bucket", required=true) String bucket, @JsonProperty(value="prefix", required=true) String prefix) {
        this.bucket = bucket;
        this.prefix = prefix;
    }

    public StorageConnector createStorageConnector(File taskTempDir) {
        File tempDirFile;
        String exportConfigTempDir = this.googleExportConfig.getTempLocalDir();
        File file = tempDirFile = exportConfigTempDir != null ? new File(exportConfigTempDir) : taskTempDir;
        if (tempDirFile == null) {
            throw DruidException.defensive((String)"Couldn't find temporary directory for export.", (Object[])new Object[0]);
        }
        List<String> allowedExportPaths = this.googleExportConfig.getAllowedExportPaths();
        if (allowedExportPaths == null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.NOT_FOUND).build("The runtime property `druid.export.storage.google.allowedExportPaths` must be configured for GCS export.", new Object[0]);
        }
        GoogleExportStorageProvider.validatePrefix(allowedExportPaths, this.bucket, this.prefix);
        GoogleOutputConfig googleOutputConfig = new GoogleOutputConfig(this.bucket, this.prefix, tempDirFile, this.googleExportConfig.getChunkSize(), this.googleExportConfig.getMaxRetry());
        return new GoogleStorageConnector(googleOutputConfig, this.googleStorage, this.googleInputDataConfig);
    }

    @VisibleForTesting
    static void validatePrefix(@NotNull List<String> allowedExportPaths, String bucket, String prefix) {
        URI providedUri = new CloudObjectLocation(bucket, prefix).toUri("gs");
        for (String path : allowedExportPaths) {
            URI allowedUri = URI.create(path);
            if (!GoogleExportStorageProvider.validateUri(allowedUri, providedUri)) continue;
            return;
        }
        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("None of the allowed prefixes matched the input path [%s]. Please reach out to the cluster admin for the whitelisted paths for export. The paths are controlled via the property `druid.export.storage.google.allowedExportPaths`.", new Object[]{providedUri});
    }

    private static boolean validateUri(URI allowedUri, URI providedUri) {
        if (!allowedUri.getHost().equals(providedUri.getHost())) {
            return false;
        }
        String allowedPath = StringUtils.maybeAppendTrailingSlash((String)allowedUri.getPath());
        String providedPath = StringUtils.maybeAppendTrailingSlash((String)providedUri.getPath());
        return providedPath.startsWith(allowedPath);
    }

    @JsonProperty(value="bucket")
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty(value="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    @JsonIgnore
    public String getResourceType() {
        return TYPE_NAME;
    }

    @JsonIgnore
    public String getBasePath() {
        return new CloudObjectLocation(this.bucket, this.prefix).toUri("gs").toString();
    }

    public String getFilePathForManifest(String fileName) {
        return new CloudObjectLocation(this.bucket, JOINER.join((Object)this.prefix, (Object)fileName, new Object[0])).toUri("gs").toString();
    }
}

