/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogramBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class FixedBucketsHistogramBufferAggregator
implements BufferAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final FixedBucketsHistogramBufferAggregatorHelper innerAggregator;

    public FixedBucketsHistogramBufferAggregator(BaseObjectColumnValueSelector selector, double lowerLimit, double upperLimit, int numBuckets, FixedBucketsHistogram.OutlierHandlingMode outlierHandlingMode) {
        this.selector = selector;
        this.innerAggregator = new FixedBucketsHistogramBufferAggregatorHelper(lowerLimit, upperLimit, numBuckets, outlierHandlingMode);
    }

    public void init(ByteBuffer buf, int position) {
        this.innerAggregator.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        Object val = this.selector.getObject();
        this.innerAggregator.aggregate(buf, position, val);
    }

    public Object get(ByteBuffer buf, int position) {
        return this.innerAggregator.get(buf, position);
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("FixedBucketsHistogramBufferAggregator does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("FixedBucketsHistogramBufferAggregator does not support getLong()");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("FixedBucketsHistogramBufferAggregator does not support getDouble()");
    }

    public void close() {
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", (Object)this.selector);
    }
}

