/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.variance.VarianceAggregatorCollector;
import org.apache.druid.query.aggregation.variance.VarianceBufferAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class VarianceFloatVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public VarianceFloatVectorAggregator(VectorValueSelector selector) {
        this.selector = selector;
    }

    public void init(ByteBuffer buf, int position) {
        VarianceBufferAggregator.doInit(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        float[] vector = this.selector.getFloatVector();
        long count = 0L;
        double sum = 0.0;
        double nvariance = 0.0;
        boolean[] nulls = this.selector.getNullVector();
        for (int i = startRow; i < endRow; ++i) {
            if (nulls != null && nulls[i]) continue;
            ++count;
            sum += (double)vector[i];
        }
        double mean = sum / (double)count;
        if (count > 1L) {
            for (int i = startRow; i < endRow; ++i) {
                if (nulls != null && nulls[i]) continue;
                nvariance += ((double)vector[i] - mean) * ((double)vector[i] - mean);
            }
        }
        VarianceAggregatorCollector previous = new VarianceAggregatorCollector(VarianceBufferAggregator.getCount(buf, position), VarianceBufferAggregator.getSum(buf, position), VarianceBufferAggregator.getVariance(buf, position));
        previous.fold(new VarianceAggregatorCollector(count, sum, nvariance));
        VarianceBufferAggregator.writeNVariance(buf, position, previous.count, previous.sum, previous.nvariance);
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        float[] vector = this.selector.getFloatVector();
        boolean[] nulls = this.selector.getNullVector();
        for (int i = 0; i < numRows; ++i) {
            int row;
            int position = positions[i] + positionOffset;
            int n = row = rows != null ? rows[i] : i;
            if (nulls != null && nulls[row]) continue;
            VarianceAggregatorCollector previous = VarianceBufferAggregator.getVarianceCollector(buf, position);
            previous.add(vector[row]);
            VarianceBufferAggregator.writeNVariance(buf, position, previous.count, previous.sum, previous.nvariance);
        }
    }

    @Nullable
    public VarianceAggregatorCollector get(ByteBuffer buf, int position) {
        return VarianceBufferAggregator.getVarianceCollector(buf, position);
    }

    public void close() {
    }
}

