/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchOperations;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.SafeWritableMemory;

public class KllFloatsSketchObjectStrategy
implements ObjectStrategy<KllFloatsSketch> {
    public int compare(KllFloatsSketch s1, KllFloatsSketch s2) {
        return KllFloatsSketchAggregatorFactory.COMPARATOR.compare(s1, s2);
    }

    public KllFloatsSketch fromByteBuffer(ByteBuffer buffer, int numBytes) {
        if (numBytes == 0) {
            return KllFloatsSketchOperations.EMPTY_SKETCH;
        }
        return KllFloatsSketch.wrap((Memory)Memory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buffer.position(), (long)numBytes));
    }

    public Class<KllFloatsSketch> getClazz() {
        return KllFloatsSketch.class;
    }

    public byte[] toBytes(KllFloatsSketch sketch) {
        if (sketch == null || sketch.isEmpty()) {
            return ByteArrays.EMPTY_ARRAY;
        }
        return sketch.toByteArray();
    }

    @Nullable
    public KllFloatsSketch fromByteBufferSafe(ByteBuffer buffer, int numBytes) {
        if (numBytes == 0) {
            return KllFloatsSketchOperations.EMPTY_SKETCH;
        }
        return KllFloatsSketch.wrap((Memory)SafeWritableMemory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buffer.position(), (long)numBytes));
    }
}

