/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;

public class PreJoinableClause {
    private final String prefix;
    private final DataSource dataSource;
    private final JoinType joinType;
    private final JoinConditionAnalysis condition;
    private final JoinAlgorithm joinAlgorithm;

    public PreJoinableClause(JoinDataSource joinDataSource) {
        this.prefix = JoinPrefixUtils.validatePrefix(joinDataSource.getRightPrefix());
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)joinDataSource.getRight(), (Object)"dataSource");
        this.joinType = (JoinType)Preconditions.checkNotNull((Object)joinDataSource.getJoinType(), (Object)"joinType");
        this.condition = (JoinConditionAnalysis)Preconditions.checkNotNull((Object)joinDataSource.getConditionAnalysis(), (Object)"condition");
        this.joinAlgorithm = joinDataSource.getJoinAlgorithm();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSource maybeUnwrapRestrictedDataSource() {
        if (this.dataSource instanceof RestrictedDataSource) {
            RestrictedDataSource restricted = (RestrictedDataSource)this.dataSource;
            if (restricted.getPolicy() instanceof NoRestrictionPolicy) {
                return restricted.getBase();
            }
            throw new QueryUnsupportedException(StringUtils.format("Restricted data source [%s] with policy [%s] is not supported", restricted.getBase(), restricted.getPolicy()));
        }
        return this.dataSource;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public JoinConditionAnalysis getCondition() {
        return this.condition;
    }

    @Nullable
    public JoinAlgorithm getJoinAlgorithm() {
        return this.joinAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreJoinableClause that = (PreJoinableClause)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.dataSource, that.dataSource) && this.joinType == that.joinType && Objects.equals(this.condition, that.condition) && this.joinAlgorithm == that.joinAlgorithm;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.dataSource, this.joinType, this.condition, this.joinAlgorithm});
    }

    public String toString() {
        return "JoinClause{prefix='" + this.prefix + "', dataSource=" + String.valueOf(this.dataSource) + ", joinType=" + String.valueOf(this.joinType) + ", condition=" + String.valueOf(this.condition) + ", joinAlgorithm=" + String.valueOf((Object)this.joinAlgorithm) + "}";
    }

    public JoinDataSource makeUpdatedJoinDataSource(DataSource newSource, DimFilter joinBaseFilter, JoinableFactoryWrapper joinableFactoryWrapper) {
        PreJoinableClause clause = this;
        return JoinDataSource.create(newSource, clause.getDataSource(), clause.getPrefix(), clause.getCondition(), clause.getJoinType(), joinBaseFilter, joinableFactoryWrapper, clause.getJoinAlgorithm());
    }
}

