/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types.numerics;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.types.ConvertResult;
import com.github.rvesse.airline.types.DefaultTypeConverter;
import com.github.rvesse.airline.types.TypeConverter;
import com.github.rvesse.airline.types.TypeConverterProvider;
import com.github.rvesse.airline.types.numerics.NumericTypeConverter;

public class DefaultNumericConverter
implements TypeConverterProvider,
NumericTypeConverter {
    @Override
    public <T> TypeConverter getTypeConverter(OptionMetadata option, ParseState<T> state) {
        return new DefaultTypeConverter(this);
    }

    @Override
    public <T> TypeConverter getTypeConverter(ArgumentsMetadata arguments, ParseState<T> state) {
        return new DefaultTypeConverter(this);
    }

    @Override
    public ConvertResult tryConvertNumerics(String name, Class<?> type, String value) {
        try {
            if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
                return this.tryConvertByte(name, value);
            }
            if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
                return this.tryConvertShort(name, value);
            }
            if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
                return this.tryConvertInteger(name, value);
            }
            if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
                return this.tryConvertLong(name, value);
            }
            if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
                return this.tryConvertFloat(name, value);
            }
            if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
                return this.tryConvertDouble(name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ConvertResult.FAILURE;
    }

    protected ConvertResult tryConvertDouble(String name, String value) {
        return new ConvertResult(Double.valueOf(value));
    }

    protected ConvertResult tryConvertFloat(String name, String value) {
        return new ConvertResult(Float.valueOf(value));
    }

    protected ConvertResult tryConvertLong(String name, String value) {
        return new ConvertResult(Long.valueOf(value));
    }

    protected ConvertResult tryConvertInteger(String name, String value) {
        return new ConvertResult(Integer.valueOf(value));
    }

    protected ConvertResult tryConvertShort(String name, String value) {
        return new ConvertResult(Short.valueOf(value));
    }

    protected ConvertResult tryConvertByte(String name, String value) {
        return new ConvertResult(Byte.valueOf(value));
    }
}

