/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.resources;

import com.github.rvesse.airline.parser.resources.ResourceLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileLocator
implements ResourceLocator {
    public static final String FILE_URI_PREFIX = "file://";

    protected String resolve(String searchLocation) {
        if (searchLocation.startsWith(FILE_URI_PREFIX)) {
            return searchLocation.substring(FILE_URI_PREFIX.length());
        }
        return searchLocation;
    }

    @Override
    public InputStream open(String searchLocation, String resourceName) throws IOException {
        if (searchLocation == null) {
            return null;
        }
        File f = new File(new File(searchLocation = this.resolve(searchLocation)), resourceName);
        if (f.exists() && f.isFile() && f.canRead()) {
            return new FileInputStream(f);
        }
        f = new File(searchLocation);
        if (f.exists() && f.isFile() && f.canRead()) {
            return new FileInputStream(f);
        }
        return null;
    }
}

