/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.cli.CliUsageHelper;
import com.github.rvesse.airline.help.common.AbstractPrintedGlobalUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.aliases.UserAliasesSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CliGlobalUsageGenerator<T>
extends AbstractPrintedGlobalUsageGenerator<T> {
    private final CliUsageHelper helper;

    public CliGlobalUsageGenerator() {
        this(79, UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageGenerator(boolean includeHidden) {
        this(79, UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageGenerator(int columns) {
        this(columns, UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageGenerator(int columns, boolean includeHidden) {
        this(columns, UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageGenerator(int columnSize, Comparator<? super HelpHint> hintComparator, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator, boolean includeHidden) {
        super(columnSize, hintComparator, optionComparator, commandComparator, commandGroupComparator, includeHidden);
        this.helper = this.createHelper(optionComparator, includeHidden);
    }

    protected CliUsageHelper createHelper(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        return new CliUsageHelper(optionComparator, includeHidden);
    }

    @Override
    protected void usage(GlobalMetadata<T> global, UsagePrinter out) throws IOException {
        this.outputDescription(out, global);
        ArrayList<HelpSection> preSections = new ArrayList<HelpSection>();
        ArrayList<HelpSection> postSections = new ArrayList<HelpSection>();
        this.findHelpSections(global, preSections, postSections);
        for (HelpSection section : preSections) {
            this.helper.outputHelpSection(out, section);
        }
        this.outputSynopsis(out, global);
        List<OptionMetadata> options = this.sortOptions(global.getOptions());
        if (options.size() > 0) {
            this.helper.outputOptions(out, options);
        }
        this.outputCommandList(out, global);
        if (global.getParserConfiguration().getUserAliasesSource() != null) {
            this.outputUserAliases(out, global, global.getParserConfiguration().getUserAliasesSource());
        }
        for (HelpSection section : postSections) {
            this.helper.outputHelpSection(out, section);
        }
    }

    protected void outputCommandList(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        out.append("COMMANDS").newline();
        UsagePrinter commandPrinter = out.newIndentedPrinter(8);
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            this.outputCommandDescription(commandPrinter, null, command);
        }
        this.outputGroupCommandsList(commandPrinter, global, global.getCommandGroups());
    }

    protected void outputGroupCommandsList(UsagePrinter out, GlobalMetadata<T> global, List<CommandGroupMetadata> groups) throws IOException {
        if (groups.size() == 0) {
            return;
        }
        for (CommandGroupMetadata group : this.sortCommandGroups(groups)) {
            if (group.isHidden() && !this.includeHidden()) continue;
            for (CommandMetadata command : this.sortCommands(group.getCommands())) {
                this.outputCommandDescription(out, group, command);
            }
            if (group.getSubGroups().size() <= 0) continue;
            UsagePrinter subGroupPrinter = out.newIndentedPrinter(4);
            this.outputGroupCommandsList(subGroupPrinter, global, group.getSubGroups());
        }
    }

    protected void outputSynopsis(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        out.append("SYNOPSIS").newline();
        out.newIndentedPrinter(8).newPrinterWithHangingIndent(8).append(global.getName()).appendWords(this.toSynopsisUsage(global.getOptions())).append("<command> [ <args> ]").newline().newline();
    }

    protected void outputDescription(UsagePrinter out, GlobalMetadata<T> global) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append("-").append(global.getDescription()).newline().newline();
    }

    protected void outputCommandDescription(UsagePrinter out, CommandGroupMetadata group, CommandMetadata command) throws IOException {
        if (!command.isHidden() || this.includeHidden()) {
            if (group != null) {
                out.append(group.getName());
            }
            out.append(command.getName()).newline();
            if (command.getDescription() != null) {
                out.newIndentedPrinter(4).append(command.getDescription()).newline();
            }
            out.newline();
        }
    }

    protected void outputUserAliases(UsagePrinter out, GlobalMetadata<T> global, UserAliasesSource<T> userAliases) throws IOException {
        if (userAliases == null) {
            return;
        }
        out.append("USER DEFINED ALIASES").newline();
        UsagePrinter aliasPrinter = out.newIndentedPrinter(8);
        aliasPrinter.append(String.format("This CLI supports user defined aliases which may be placed in a %s file located in %s the following location(s):", userAliases.getFilename(), userAliases.getSearchLocations().size() > 1 ? "one/more of" : "")).newline().newline();
        UsagePrinter locationPrinter = aliasPrinter.newIndentedPrinter(4);
        int i = 1;
        for (String location : userAliases.getSearchLocations()) {
            locationPrinter.append(String.format("%d) %s", i, location)).newline();
            ++i;
        }
        locationPrinter.flush();
        aliasPrinter.newline();
        if (userAliases.getSearchLocations().size() > 1) {
            aliasPrinter.append("Where the file exists in multiple locations then the files are merged together with the earlier locations taking precedence.").newline().newline();
        }
        aliasPrinter.append("This file contains aliases defined in Java properties file style e.g.").newline().newline();
        UsagePrinter examplePrinter = aliasPrinter.newIndentedPrinter(4);
        examplePrinter.append(String.format("%sfoo=bar --flag", StringUtils.isNotBlank((CharSequence)userAliases.getPrefix()) ? userAliases.getPrefix() : "")).newline().newline();
        examplePrinter.flush();
        aliasPrinter.append("Here an alias foo is defined which causes the bar command to be invoked with the --flag option passed to it.");
        if (StringUtils.isNotBlank((CharSequence)userAliases.getPrefix())) {
            aliasPrinter.append("Aliases are distinguished from other properties in the file by the prefix '" + userAliases.getPrefix() + "' as seen in the example.").newline();
        }
        aliasPrinter.newline();
        aliasPrinter.append("Alias definitions are subject to the following conditions:").newline().newline();
        UsagePrinter restrictionsPrinter = aliasPrinter.newIndentedPrinter(4);
        if (global.getParserConfiguration().aliasesOverrideBuiltIns()) {
            restrictionsPrinter.append("- Aliases may override existing commands");
        } else {
            restrictionsPrinter.append("- Aliases cannot override existing commands");
        }
        restrictionsPrinter.newline();
        if (global.getParserConfiguration().aliasesMayChain()) {
            restrictionsPrinter.append("- Aliases may be defined in terms of other aliases provided circular references are not created");
        } else {
            restrictionsPrinter.append("- Aliases cannot be defined in terms of other aliases");
        }
        restrictionsPrinter.newline();
        restrictionsPrinter.flush();
    }
}

