/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler.intercept;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.exception.FilterException;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.NettyRequestSender;

public class ResponseFiltersInterceptor {
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;

    ResponseFiltersInterceptor(AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.config = config;
        this.requestSender = requestSender;
    }

    public boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpHeaders responseHeaders) {
        FilterContext<?> fc = new FilterContext.FilterContextBuilder(handler, future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
        for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
            try {
                fc = asyncFilter.filter(fc);
            }
            catch (FilterException fe) {
                this.requestSender.abort(channel, future, fe);
            }
        }
        future.setAsyncHandler(fc.getAsyncHandler());
        if (fc.replayRequest()) {
            this.requestSender.replayRequest(future, fc, channel);
            return true;
        }
        return false;
    }
}

