/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.iterator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.parsers.CloseableIterator;

public class DefaultIndexTaskInputRowIteratorBuilder
implements IndexTaskInputRowIteratorBuilder {
    private CloseableIterator<InputRow> delegate = null;
    private GranularitySpec granularitySpec = null;
    private final List<HandlingInputRowIterator.InputRowHandler> appendedInputRowHandlers = new ArrayList<HandlingInputRowIterator.InputRowHandler>();

    @Override
    public DefaultIndexTaskInputRowIteratorBuilder delegate(CloseableIterator<InputRow> inputRowIterator) {
        this.delegate = inputRowIterator;
        return this;
    }

    @Override
    public DefaultIndexTaskInputRowIteratorBuilder granularitySpec(GranularitySpec granularitySpec) {
        this.granularitySpec = granularitySpec;
        return this;
    }

    @Override
    public HandlingInputRowIterator build() {
        Preconditions.checkNotNull(this.delegate, (Object)"delegate required");
        Preconditions.checkNotNull((Object)this.granularitySpec, (Object)"granularitySpec required");
        ImmutableList.Builder handlersBuilder = ImmutableList.builder().addAll(this.appendedInputRowHandlers);
        return new HandlingInputRowIterator(this.delegate, (List)handlersBuilder.build());
    }

    DefaultIndexTaskInputRowIteratorBuilder appendInputRowHandler(HandlingInputRowIterator.InputRowHandler inputRowHandler) {
        this.appendedInputRowHandlers.add(inputRowHandler);
        return this;
    }
}

