/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTaskRunner;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexingPhaseProgress;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.TaskHistory;
import org.apache.druid.indexing.common.task.batch.parallel.TaskMonitor;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public abstract class ParallelIndexPhaseRunner<SubTaskType extends Task, SubTaskReportType extends SubTaskReport>
implements ParallelIndexTaskRunner<SubTaskType, SubTaskReportType> {
    private static final Logger LOG = new Logger(ParallelIndexPhaseRunner.class);
    private final TaskToolbox toolbox;
    private final String taskId;
    private final String groupId;
    private final String baseSubtaskSpecName;
    private final ParallelIndexTuningConfig tuningConfig;
    private final Map<String, Object> context;
    private final int maxNumConcurrentSubTasks;
    private final BlockingQueue<TaskMonitor.SubTaskCompleteEvent<SubTaskType>> taskCompleteEvents = new LinkedBlockingDeque<TaskMonitor.SubTaskCompleteEvent<SubTaskType>>();
    private volatile boolean subTaskScheduleAndMonitorStopped;
    private volatile TaskMonitor<SubTaskType, SubTaskReportType> taskMonitor;
    private volatile String stopReason;
    private int nextSpecId = 0;

    ParallelIndexPhaseRunner(TaskToolbox toolbox, String taskId, String groupId, String baseSubtaskSpecName, ParallelIndexTuningConfig tuningConfig, Map<String, Object> context) {
        this.toolbox = toolbox;
        this.taskId = taskId;
        this.groupId = groupId;
        this.baseSubtaskSpecName = baseSubtaskSpecName;
        this.tuningConfig = tuningConfig;
        this.context = context;
        this.maxNumConcurrentSubTasks = tuningConfig.getMaxNumConcurrentSubTasks();
    }

    abstract Iterator<SubTaskSpec<SubTaskType>> subTaskSpecIterator() throws IOException;

    abstract int estimateTotalNumSubTasks() throws IOException;

    public Runnable getSubtaskCompletionCallback(TaskMonitor.SubTaskCompleteEvent<?> event) {
        return () -> {};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskState run() throws Exception {
        CountingSubTaskSpecIterator subTaskSpecIterator = new CountingSubTaskSpecIterator(this.subTaskSpecIterator());
        if (!subTaskSpecIterator.hasNext()) {
            LOG.warn("There's no input split to process", new Object[0]);
            return TaskState.SUCCESS;
        }
        long taskStatusCheckingPeriod = this.tuningConfig.getTaskStatusCheckPeriodMs();
        this.taskMonitor = new TaskMonitor(this.toolbox.getOverlordClient(), this.tuningConfig.getMaxRetry(), this.estimateTotalNumSubTasks(), this.getSubtaskTimeoutMillisFromContext());
        TaskState state = TaskState.RUNNING;
        this.taskMonitor.start(taskStatusCheckingPeriod);
        try {
            LOG.info("Submitting initial tasks", new Object[0]);
            while (this.isRunning() && subTaskSpecIterator.hasNext() && this.taskMonitor.getNumRunningTasks() < this.maxNumConcurrentSubTasks) {
                this.submitNewTask(this.taskMonitor, (SubTaskSpec<SubTaskType>)subTaskSpecIterator.next());
            }
            LOG.info("Waiting for subTasks to be completed", new Object[0]);
            block8: while (this.isRunning()) {
                TaskMonitor.SubTaskCompleteEvent<SubTaskType> taskCompleteEvent = this.taskCompleteEvents.poll(taskStatusCheckingPeriod, TimeUnit.MILLISECONDS);
                if (taskCompleteEvent == null) continue;
                TaskState completeState = taskCompleteEvent.getLastState();
                this.getSubtaskCompletionCallback(taskCompleteEvent).run();
                switch (completeState) {
                    case SUCCESS: {
                        TaskStatusPlus completeStatus = taskCompleteEvent.getLastStatus();
                        if (completeStatus == null) {
                            throw new ISE("Last status of complete task is missing!", new Object[0]);
                        }
                        if (!subTaskSpecIterator.hasNext()) {
                            if (this.taskMonitor.getNumRunningTasks() != 0 || !this.taskCompleteEvents.isEmpty()) continue block8;
                            this.subTaskScheduleAndMonitorStopped = true;
                            if (subTaskSpecIterator.count == this.taskMonitor.getNumSucceededTasks()) {
                                state = TaskState.SUCCESS;
                                continue block8;
                            }
                            ParallelIndexingPhaseProgress monitorStatus = this.taskMonitor.getProgress();
                            throw new ISE("Expected [%d] tasks to succeed, but we got [%d] succeeded tasks and [%d] failed tasks", new Object[]{subTaskSpecIterator.count, monitorStatus.getSucceeded(), monitorStatus.getFailed()});
                        }
                        if (this.taskMonitor.getNumRunningTasks() >= this.maxNumConcurrentSubTasks) continue block8;
                        this.submitNewTask(this.taskMonitor, (SubTaskSpec<SubTaskType>)subTaskSpecIterator.next());
                        continue block8;
                    }
                    case FAILED: {
                        state = TaskState.FAILED;
                        this.subTaskScheduleAndMonitorStopped = true;
                        TaskStatusPlus lastStatus = taskCompleteEvent.getLastStatus();
                        if (lastStatus != null) {
                            LOG.error("Failed because of the failed sub task[%s]", new Object[]{lastStatus.getId()});
                            continue block8;
                        }
                        SubTaskSpec<SubTaskType> spec = taskCompleteEvent.getSpec();
                        LOG.error("Failed to process spec[%s] with an unknown last status", new Object[]{spec.getId()});
                        continue block8;
                    }
                }
                throw new ISE("spec[%s] is in an invalid state[%s]", new Object[]{taskCompleteEvent.getSpec().getId(), completeState});
            }
        }
        finally {
            this.stopInternal();
            if (!state.isComplete()) {
                state = TaskState.FAILED;
            }
        }
        return state;
    }

    private boolean isRunning() {
        return !this.subTaskScheduleAndMonitorStopped && !Thread.currentThread().isInterrupted();
    }

    private void submitNewTask(TaskMonitor<SubTaskType, SubTaskReportType> taskMonitor, final SubTaskSpec<SubTaskType> spec) {
        LOG.info("Submitting a new task for spec[%s]", new Object[]{spec.getId()});
        ListenableFuture<TaskMonitor.SubTaskCompleteEvent<SubTaskType>> future = taskMonitor.submit(spec);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<TaskMonitor.SubTaskCompleteEvent<SubTaskType>>(){

            public void onSuccess(TaskMonitor.SubTaskCompleteEvent<SubTaskType> completeEvent) {
                ParallelIndexPhaseRunner.this.taskCompleteEvents.offer(completeEvent);
            }

            public void onFailure(Throwable t) {
                LOG.error(t, "Error while running a task for spec[%s]", new Object[]{spec.getId()});
                ParallelIndexPhaseRunner.this.taskCompleteEvents.offer(TaskMonitor.SubTaskCompleteEvent.fail(spec, t));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void stopGracefully(String stopReason) {
        this.subTaskScheduleAndMonitorStopped = true;
        this.stopReason = stopReason;
        this.stopInternal();
    }

    private void stopInternal() {
        LOG.info("Cleaning up resources", new Object[0]);
        this.taskCompleteEvents.clear();
        if (this.taskMonitor != null) {
            this.taskMonitor.stop();
        }
    }

    @Override
    public void collectReport(SubTaskReportType report) {
        assert (this.taskMonitor != null);
        this.taskMonitor.collectReport(report);
    }

    @Override
    public Map<String, SubTaskReportType> getReports() {
        return this.taskMonitor == null ? Collections.emptyMap() : this.taskMonitor.getReports();
    }

    @Override
    public ParallelIndexingPhaseProgress getProgress() {
        return this.taskMonitor == null ? ParallelIndexingPhaseProgress.notRunning() : this.taskMonitor.getProgress();
    }

    @Override
    public Set<String> getRunningTaskIds() {
        return this.taskMonitor == null ? Collections.emptySet() : this.taskMonitor.getRunningTaskIds();
    }

    @Override
    public List<SubTaskSpec<SubTaskType>> getSubTaskSpecs() {
        if (this.taskMonitor != null) {
            List<SubTaskSpec<SubTaskType>> runningSubTaskSpecs = this.taskMonitor.getRunningSubTaskSpecs();
            List<SubTaskSpec<SubTaskType>> completeSubTaskSpecs = this.taskMonitor.getCompleteSubTaskSpecs();
            HashMap subTaskSpecMap = Maps.newHashMapWithExpectedSize((int)(runningSubTaskSpecs.size() + completeSubTaskSpecs.size()));
            runningSubTaskSpecs.forEach(spec -> subTaskSpecMap.put(spec.getId(), spec));
            completeSubTaskSpecs.forEach(spec -> subTaskSpecMap.put(spec.getId(), spec));
            return new ArrayList<SubTaskSpec<SubTaskType>>(subTaskSpecMap.values());
        }
        return Collections.emptyList();
    }

    @Override
    public List<SubTaskSpec<SubTaskType>> getRunningSubTaskSpecs() {
        return this.taskMonitor == null ? Collections.emptyList() : this.taskMonitor.getRunningSubTaskSpecs();
    }

    @Override
    public List<SubTaskSpec<SubTaskType>> getCompleteSubTaskSpecs() {
        return this.taskMonitor == null ? Collections.emptyList() : this.taskMonitor.getCompleteSubTaskSpecs();
    }

    @Override
    @Nullable
    public SubTaskSpec<SubTaskType> getSubTaskSpec(String subTaskSpecId) {
        if (this.taskMonitor != null) {
            TaskMonitor.MonitorEntry monitorEntry = this.taskMonitor.getRunningTaskMonitorEntry(subTaskSpecId);
            TaskHistory<SubTaskType> taskHistory = this.taskMonitor.getCompleteSubTaskSpecHistory(subTaskSpecId);
            SubTaskSpec<Object> subTaskSpec = monitorEntry != null ? monitorEntry.getSpec() : (taskHistory != null ? taskHistory.getSpec() : null);
            return subTaskSpec;
        }
        return null;
    }

    @Override
    @Nullable
    public ParallelIndexTaskRunner.SubTaskSpecStatus getSubTaskState(String subTaskSpecId) {
        if (this.taskMonitor == null) {
            return null;
        }
        TaskMonitor.MonitorEntry monitorEntry = this.taskMonitor.getRunningTaskMonitorEntry(subTaskSpecId);
        TaskHistory<SubTaskType> taskHistory = this.taskMonitor.getCompleteSubTaskSpecHistory(subTaskSpecId);
        ParallelIndexTaskRunner.SubTaskSpecStatus subTaskSpecStatus = monitorEntry != null ? new ParallelIndexTaskRunner.SubTaskSpecStatus((SinglePhaseSubTaskSpec)monitorEntry.getSpec(), monitorEntry.getRunningStatus(), monitorEntry.getTaskHistory()) : (taskHistory != null && !taskHistory.isEmpty() ? new ParallelIndexTaskRunner.SubTaskSpecStatus((SinglePhaseSubTaskSpec)taskHistory.getSpec(), null, taskHistory.getAttemptHistory()) : null);
        return subTaskSpecStatus;
    }

    @Override
    @Nullable
    public TaskHistory<SubTaskType> getCompleteSubTaskSpecAttemptHistory(String subTaskSpecId) {
        if (this.taskMonitor == null) {
            return null;
        }
        return this.taskMonitor.getCompleteSubTaskSpecHistory(subTaskSpecId);
    }

    @Override
    public String getStopReason() {
        return this.stopReason;
    }

    String getTaskId() {
        return this.taskId;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getBaseSubtaskSpecName() {
        return this.baseSubtaskSpecName;
    }

    Map<String, Object> getContext() {
        return this.context;
    }

    ParallelIndexTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    TaskToolbox getToolbox() {
        return this.toolbox;
    }

    @Nullable
    @VisibleForTesting
    TaskMonitor<SubTaskType, SubTaskReportType> getTaskMonitor() {
        return this.taskMonitor;
    }

    @VisibleForTesting
    int getAndIncrementNextSpecId() {
        return this.nextSpecId++;
    }

    private long getSubtaskTimeoutMillisFromContext() {
        return ((Number)this.context.getOrDefault("subTaskTimeoutMillis", 0L)).longValue();
    }

    private class CountingSubTaskSpecIterator
    implements Iterator<SubTaskSpec<SubTaskType>> {
        private final Iterator<SubTaskSpec<SubTaskType>> delegate;
        private int count;

        private CountingSubTaskSpecIterator(Iterator<SubTaskSpec<SubTaskType>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SubTaskSpec<SubTaskType> next() {
            if (!this.delegate.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            return this.delegate.next();
        }
    }
}

