/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.google.common.collect.Lists;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.druid.data.input.avro.GenericAvroJsonProvider;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.NotImplementedMappingProvider;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;

public class AvroFlattenerMaker
implements ObjectFlatteners.FlattenerMaker<GenericRecord> {
    private final JsonProvider avroJsonProvider;
    private final Configuration jsonPathConfiguration;
    private static final EnumSet<Schema.Type> ROOT_TYPES = EnumSet.of(Schema.Type.STRING, new Schema.Type[]{Schema.Type.BYTES, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.ENUM, Schema.Type.FIXED});
    private final boolean fromPigAvroStorage;
    private final boolean binaryAsString;
    private final boolean discoverNestedFields;

    private static boolean isPrimitive(Schema schema) {
        return ROOT_TYPES.contains(schema.getType());
    }

    private static boolean isPrimitiveArray(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.ARRAY) && AvroFlattenerMaker.isPrimitive(schema.getElementType());
    }

    private static boolean isOptionalPrimitive(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) && (AvroFlattenerMaker.isPrimitive((Schema)schema.getTypes().get(1)) || AvroFlattenerMaker.isPrimitiveArray((Schema)schema.getTypes().get(1))) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL) && (AvroFlattenerMaker.isPrimitive((Schema)schema.getTypes().get(0)) || AvroFlattenerMaker.isPrimitiveArray((Schema)schema.getTypes().get(0))));
    }

    private static boolean isFieldPrimitive(Schema.Field field) {
        return AvroFlattenerMaker.isPrimitive(field.schema()) || AvroFlattenerMaker.isPrimitiveArray(field.schema()) || AvroFlattenerMaker.isOptionalPrimitive(field.schema());
    }

    public AvroFlattenerMaker(boolean fromPigAvroStorage, boolean binaryAsString, boolean extractUnionsByType, boolean discoverNestedFields) {
        this.fromPigAvroStorage = fromPigAvroStorage;
        this.binaryAsString = binaryAsString;
        this.discoverNestedFields = discoverNestedFields;
        this.avroJsonProvider = new GenericAvroJsonProvider(extractUnionsByType);
        this.jsonPathConfiguration = Configuration.builder().jsonProvider(this.avroJsonProvider).mappingProvider((MappingProvider)new NotImplementedMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    }

    public Set<String> discoverRootFields(GenericRecord obj) {
        if (this.discoverNestedFields) {
            return obj.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toSet());
        }
        return obj.getSchema().getFields().stream().filter(AvroFlattenerMaker::isFieldPrimitive).map(Schema.Field::name).collect(Collectors.toSet());
    }

    public Object getRootField(GenericRecord record, String key) {
        if (record.getSchema().getField(key) != null) {
            return this.transformValue(record.get(key));
        }
        return null;
    }

    public Function<GenericRecord, Object> makeJsonPathExtractor(String expr) {
        JsonPath jsonPath = JsonPath.compile((String)expr, (Predicate[])new Predicate[0]);
        return record -> this.transformValue(jsonPath.read(record, this.jsonPathConfiguration));
    }

    public Function<GenericRecord, Object> makeJsonQueryExtractor(String expr) {
        throw new UnsupportedOperationException("Avro + JQ not supported");
    }

    public Function<GenericRecord, Object> makeJsonTreeExtractor(List<String> nodes) {
        if (nodes.size() == 1) {
            return record -> this.getRootField((GenericRecord)record, (String)nodes.get(0));
        }
        throw new UnsupportedOperationException("Avro + nested tree extraction not supported");
    }

    public JsonProvider getJsonProvider() {
        return this.avroJsonProvider;
    }

    public Object finalizeConversionForMap(Object o) {
        return this.transformValue(o);
    }

    private Object transformValue(Object field) {
        if (this.fromPigAvroStorage && field instanceof GenericArray) {
            return Lists.transform((List)((List)field), item -> String.valueOf(((GenericRecord)item).get(0)));
        }
        if (field instanceof ByteBuffer) {
            if (this.binaryAsString) {
                return StringUtils.fromUtf8((byte[])((ByteBuffer)field).array());
            }
            return ((ByteBuffer)field).array();
        }
        if (field instanceof Utf8) {
            return field.toString();
        }
        if (field instanceof List) {
            return ((List)field).stream().map(this::transformValue).collect(Collectors.toList());
        }
        if (field instanceof GenericEnumSymbol) {
            return field.toString();
        }
        if (field instanceof GenericFixed) {
            if (this.binaryAsString) {
                return StringUtils.fromUtf8((byte[])((GenericFixed)field).bytes());
            }
            return ((GenericFixed)field).bytes();
        }
        if (field instanceof Map) {
            LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>();
            Map fieldMap = (Map)field;
            for (Map.Entry entry : fieldMap.entrySet()) {
                retVal.put(String.valueOf(entry.getKey()), this.transformValue(entry.getValue()));
            }
            return retVal;
        }
        if (field instanceof GenericRecord) {
            LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>();
            GenericRecord record = (GenericRecord)field;
            for (Schema.Field key : record.getSchema().getFields()) {
                retVal.put(key.name(), this.transformValue(record.get(key.pos())));
            }
            return retVal;
        }
        return field;
    }
}

