/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.druid.common.config.Configs;
import org.apache.druid.java.util.common.ISE;

public class HadoopTaskConfig {
    private static final String HADOOP_LIB_VERSIONS = "hadoop.indexer.libs.version";
    public static final List<String> DEFAULT_DEFAULT_HADOOP_COORDINATES;
    @JsonProperty
    private final String hadoopWorkingPath;
    @JsonProperty
    private final List<String> defaultHadoopCoordinates;

    @JsonCreator
    public HadoopTaskConfig(@JsonProperty(value="hadoopWorkingPath") @Nullable String hadoopWorkingPath, @JsonProperty(value="defaultHadoopCoordinates") @Nullable List<String> defaultHadoopCoordinates) {
        this.hadoopWorkingPath = (String)Configs.valueOrDefault((Object)hadoopWorkingPath, (Object)"/tmp/druid-indexing");
        this.defaultHadoopCoordinates = (List)Configs.valueOrDefault(defaultHadoopCoordinates, DEFAULT_DEFAULT_HADOOP_COORDINATES);
    }

    @JsonProperty
    public String getHadoopWorkingPath() {
        return this.hadoopWorkingPath;
    }

    @JsonProperty
    public List<String> getDefaultHadoopCoordinates() {
        return this.defaultHadoopCoordinates;
    }

    static {
        try {
            DEFAULT_DEFAULT_HADOOP_COORDINATES = ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])IOUtils.toString((InputStream)HadoopTaskConfig.class.getResourceAsStream("/hadoop.indexer.libs.version"), (Charset)StandardCharsets.UTF_8).split(",")));
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Unable to read file %s from classpath ", new Object[]{HADOOP_LIB_VERSIONS});
        }
    }
}

