/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.endpoint;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.authentication.BasicHTTPAuthenticator;
import org.apache.druid.security.basic.authentication.db.cache.BasicAuthenticatorCacheManager;
import org.apache.druid.security.basic.authentication.endpoint.BasicAuthenticatorResourceHandler;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentialUpdate;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;

public class DefaultBasicAuthenticatorResourceHandler
implements BasicAuthenticatorResourceHandler {
    private static final Logger log = new Logger(DefaultBasicAuthenticatorResourceHandler.class);
    private static final Response NOT_FOUND_RESPONSE = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    private static final String UNKNOWN_AUTHENTICATOR_MSG_FORMAT = "Received user update for unknown authenticator[%s]";
    private final BasicAuthenticatorCacheManager cacheManager;
    private final Map<String, BasicHTTPAuthenticator> authenticatorMap;

    @Inject
    public DefaultBasicAuthenticatorResourceHandler(BasicAuthenticatorCacheManager cacheManager, AuthenticatorMapper authenticatorMapper) {
        this.cacheManager = cacheManager;
        this.authenticatorMap = new HashMap<String, BasicHTTPAuthenticator>();
        for (Map.Entry authenticatorEntry : authenticatorMapper.getAuthenticatorMap().entrySet()) {
            String authenticatorName = (String)authenticatorEntry.getKey();
            Authenticator authenticator = (Authenticator)authenticatorEntry.getValue();
            if (!(authenticator instanceof BasicHTTPAuthenticator)) continue;
            this.authenticatorMap.put(authenticatorName, (BasicHTTPAuthenticator)authenticator);
        }
    }

    @Override
    public Response getAllUsers(String authenticatorName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getUser(String authenticatorName, String userName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response createUser(String authenticatorName, String userName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response deleteUser(String authenticatorName, String userName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response updateUserCredentials(String authenticatorName, String userName, BasicAuthenticatorCredentialUpdate update) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response getCachedSerializedUserMap(String authenticatorName) {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response refreshAll() {
        return NOT_FOUND_RESPONSE;
    }

    @Override
    public Response authenticatorUserUpdateListener(String authenticatorName, byte[] serializedUserMap) {
        BasicHTTPAuthenticator authenticator = this.authenticatorMap.get(authenticatorName);
        if (authenticator == null) {
            log.error(UNKNOWN_AUTHENTICATOR_MSG_FORMAT, new Object[]{authenticatorName});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)UNKNOWN_AUTHENTICATOR_MSG_FORMAT, (Object[])new Object[]{authenticatorName}))).build();
        }
        this.cacheManager.handleAuthenticatorUserMapUpdate(authenticatorName, serializedUserMap);
        return Response.ok().build();
    }

    @Override
    public Response getLoadStatus() {
        HashMap loadStatus = new HashMap();
        this.authenticatorMap.forEach((authenticatorName, authenticator) -> loadStatus.put(authenticatorName, this.cacheManager.getUserMap((String)authenticatorName) != null));
        return Response.ok(loadStatus).build();
    }
}

