/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.server.security.Access;

public class AuthorizationResult {
    public static final AuthorizationResult ALLOW_NO_RESTRICTION = new AuthorizationResult(Permission.ALLOW_NO_RESTRICTION, null, Collections.emptyMap());
    public static final AuthorizationResult DENY = new AuthorizationResult(Permission.DENY, Access.DENIED.getMessage(), Collections.emptyMap());
    private final Permission permission;
    @Nullable
    private final String failureMessage;
    private final Map<String, Optional<Policy>> policyRestrictions;

    AuthorizationResult(Permission permission, @Nullable String failureMessage, Map<String, Optional<Policy>> policyRestrictions) {
        this.permission = permission;
        this.failureMessage = failureMessage;
        this.policyRestrictions = policyRestrictions;
        switch (permission.ordinal()) {
            case 2: {
                this.validateFailureMessageIsSet();
                this.validatePolicyRestrictionEmpty();
                return;
            }
            case 1: {
                this.validateFailureMessageNull();
                this.validatePolicyRestrictionNonEmpty();
                return;
            }
            case 0: {
                this.validateFailureMessageNull();
                this.validatePolicyRestrictionEmpty();
                return;
            }
        }
        throw DruidException.defensive((String)"unreachable", (Object[])new Object[0]);
    }

    public static AuthorizationResult deny(@Nonnull String failureMessage) {
        return new AuthorizationResult(Permission.DENY, failureMessage, Collections.emptyMap());
    }

    public static AuthorizationResult allowWithRestriction(Map<String, Optional<Policy>> policyRestrictions) {
        if (policyRestrictions.isEmpty()) {
            return ALLOW_NO_RESTRICTION;
        }
        return new AuthorizationResult(Permission.ALLOW_WITH_RESTRICTION, null, policyRestrictions);
    }

    public boolean allowBasicAccess() {
        return Permission.ALLOW_NO_RESTRICTION.equals((Object)this.permission) || Permission.ALLOW_WITH_RESTRICTION.equals((Object)this.permission);
    }

    public boolean allowAccessWithNoRestriction() {
        return Permission.ALLOW_NO_RESTRICTION.equals((Object)this.permission) || Permission.ALLOW_WITH_RESTRICTION.equals((Object)this.permission) && this.policyRestrictions.values().stream().flatMap(Optional::stream).allMatch(p -> p instanceof NoRestrictionPolicy);
    }

    public String getErrorMessage() {
        switch (this.permission.ordinal()) {
            case 2: {
                return Objects.requireNonNull(this.failureMessage);
            }
            case 1: {
                if (this.allowAccessWithNoRestriction()) break;
                return "Unauthorized";
            }
        }
        throw DruidException.defensive((String)"unreachable", (Object[])new Object[0]);
    }

    public Map<String, Optional<Policy>> getPolicyMap() {
        return this.policyRestrictions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationResult that = (AuthorizationResult)o;
        return Objects.equals((Object)this.permission, (Object)that.permission) && Objects.equals(this.failureMessage, that.failureMessage) && Objects.equals(this.policyRestrictions, that.policyRestrictions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.permission, this.failureMessage, this.policyRestrictions});
    }

    public String toString() {
        return "AuthorizationResult [permission=" + String.valueOf((Object)this.permission) + ", failureMessage=" + this.failureMessage + ", policyRestrictions=" + String.valueOf(this.policyRestrictions) + "]";
    }

    private void validateFailureMessageIsSet() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.failureMessage) ? 1 : 0) != 0, (String)"Failure message must be set for permission[%s]", (Object)((Object)this.permission));
    }

    private void validateFailureMessageNull() {
        Preconditions.checkArgument((this.failureMessage == null ? 1 : 0) != 0, (String)"Failure message must be null for permission[%s]", (Object)((Object)this.permission));
    }

    private void validatePolicyRestrictionEmpty() {
        Preconditions.checkArgument((boolean)this.policyRestrictions.isEmpty(), (String)"Policy restrictions not allowed for permission[%s]", (Object)((Object)this.permission));
    }

    private void validatePolicyRestrictionNonEmpty() {
        Preconditions.checkArgument((!this.policyRestrictions.isEmpty() ? 1 : 0) != 0, (String)"Policy restrictions must exist for permission[%s]", (Object)((Object)this.permission));
    }

    static enum Permission {
        ALLOW_NO_RESTRICTION,
        ALLOW_WITH_RESTRICTION,
        DENY;

    }
}

