/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.InventoryView;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

@Path(value="/druid/coordinator/v1/servers")
@ResourceFilters(value={StateResourceFilter.class})
public class ServersResource {
    private final InventoryView serverInventoryView;

    private static Map<String, Object> makeSimpleServer(DruidServer input) {
        return new ImmutableMap.Builder().put((Object)"host", (Object)input.getHost()).put((Object)"tier", (Object)input.getTier()).put((Object)"type", (Object)input.getType().toString()).put((Object)"priority", (Object)input.getPriority()).put((Object)"currSize", (Object)input.getCurrSize()).put((Object)"maxSize", (Object)input.getMaxSize()).build();
    }

    private static Map<String, Object> makeFullServer(DruidServer server) {
        return new ImmutableMap.Builder().put((Object)"host", (Object)server.getHost()).put((Object)"maxSize", (Object)server.getMaxSize()).put((Object)"type", (Object)server.getType().toString()).put((Object)"tier", (Object)server.getTier()).put((Object)"priority", (Object)server.getPriority()).put((Object)"segments", ServersResource.createLazySegmentsMap(server)).put((Object)"currSize", (Object)server.getCurrSize()).build();
    }

    private static Map<SegmentId, DataSegment> createLazySegmentsMap(final DruidServer server) {
        return new AbstractMap<SegmentId, DataSegment>(){

            @Override
            public Set<Map.Entry<SegmentId, DataSegment>> entrySet() {
                return new AbstractSet<Map.Entry<SegmentId, DataSegment>>(){

                    @Override
                    public Iterator<Map.Entry<SegmentId, DataSegment>> iterator() {
                        return Iterators.transform(server.iterateAllSegments().iterator(), segment -> new AbstractMap.SimpleImmutableEntry<SegmentId, DataSegment>(segment.getId(), (DataSegment)segment));
                    }

                    @Override
                    public int size() {
                        return server.getTotalSegments();
                    }
                };
            }
        };
    }

    @Inject
    public ServersResource(InventoryView serverInventoryView) {
        this.serverInventoryView = serverInventoryView;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getClusterServers(@QueryParam(value="full") String full, @QueryParam(value="simple") String simple) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity((Object)Collections2.transform(this.serverInventoryView.getInventory(), ServersResource::makeFullServer)).build();
        }
        if (simple != null) {
            return builder.entity((Object)Collections2.transform(this.serverInventoryView.getInventory(), ServersResource::makeSimpleServer)).build();
        }
        return builder.entity((Object)Collections2.transform(this.serverInventoryView.getInventory(), DruidServer::getHost)).build();
    }

    @GET
    @Path(value="/{serverName}")
    @Produces(value={"application/json"})
    public Response getServer(@PathParam(value="serverName") String serverName, @QueryParam(value="simple") String simple) {
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (simple != null) {
            return builder.entity(ServersResource.makeSimpleServer(server)).build();
        }
        return builder.entity(ServersResource.makeFullServer(server)).build();
    }

    @GET
    @Path(value="/{serverName}/segments")
    @Produces(value={"application/json"})
    public Response getServerSegments(@PathParam(value="serverName") String serverName, @QueryParam(value="full") String full) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (full != null) {
            return builder.entity(server.iterateAllSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(server.iterateAllSegments(), DataSegment::getId)).build();
    }

    @GET
    @Path(value="/{serverName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    public Response getServerSegment(@PathParam(value="serverName") String serverName, @PathParam(value="segmentId") String segmentId) {
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (SegmentId possibleSegmentId : SegmentId.iterateAllPossibleParsings((String)segmentId)) {
            DataSegment segment = server.getSegment(possibleSegmentId);
            if (segment == null) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

