/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.io.IOException;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.realtime.appenderator.SegmentPublisherHelper;
import org.apache.druid.timeline.DataSegment;

public abstract class TransactionalSegmentPublisher {
    private static final int QUIET_RETRIES = 3;
    private static final int MAX_RETRIES = 5;

    public abstract SegmentPublishResult publishAnnotatedSegments(@Nullable Set<DataSegment> var1, Set<DataSegment> var2, @Nullable Object var3, @Nullable SegmentSchemaMapping var4) throws IOException;

    public final SegmentPublishResult publishSegments(@Nullable Set<DataSegment> segmentsToBeOverwritten, Set<DataSegment> segmentsToPublish, Function<Set<DataSegment>, Set<DataSegment>> outputSegmentsAnnotateFunction, @Nullable Object commitMetadata, @Nullable SegmentSchemaMapping segmentSchemaMapping) throws IOException {
        Function<Set<DataSegment>, Set> annotateFunction = outputSegmentsAnnotateFunction.andThen(SegmentPublisherHelper::annotateShardSpec);
        Set annotatedSegmentsToPublish = annotateFunction.apply(segmentsToPublish);
        int attemptCount = 0;
        SegmentPublishResult result = this.publishAnnotatedSegments(segmentsToBeOverwritten, annotatedSegmentsToPublish, commitMetadata, segmentSchemaMapping);
        while (!result.isSuccess() && result.isRetryable() && attemptCount++ < 5) {
            TransactionalSegmentPublisher.awaitNextRetry(result, attemptCount);
            result = this.publishAnnotatedSegments(segmentsToBeOverwritten, annotatedSegmentsToPublish, commitMetadata, segmentSchemaMapping);
        }
        return result;
    }

    public boolean supportsEmptyPublish() {
        return false;
    }

    private static void awaitNextRetry(SegmentPublishResult lastResult, int attemptCount) {
        try {
            RetryUtils.awaitNextRetry((Throwable)new ISE(lastResult.getErrorMsg(), new Object[0]), (String)StringUtils.format((String)"Segment publish failed due to error[%s]", (Object[])new Object[]{lastResult.getErrorMsg()}), (int)attemptCount, (int)5, (attemptCount <= 3 ? 1 : 0) != 0);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

