/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.net.telnet;

import org.apache.hadoop.shaded.org.apache.commons.net.telnet.TelnetOptionHandler;

public class WindowSizeOptionHandler
extends TelnetOptionHandler {
    protected static final int WINDOW_SIZE = 31;
    private int width = 80;
    private int height = 24;

    public WindowSizeOptionHandler(int nWidth, int nHeight) {
        super(31, false, false, false, false);
        this.width = nWidth;
        this.height = nHeight;
    }

    public WindowSizeOptionHandler(int nWidth, int nHeight, boolean initlocal, boolean initremote, boolean acceptlocal, boolean acceptremote) {
        super(31, initlocal, initremote, acceptlocal, acceptremote);
        this.width = nWidth;
        this.height = nHeight;
    }

    @Override
    public int[] startSubnegotiationLocal() {
        int nCompoundWindowSize = this.width * 65536 + this.height;
        int nResponseSize = 5;
        if (this.width % 256 == 255) {
            ++nResponseSize;
        }
        if (this.width / 256 == 255) {
            ++nResponseSize;
        }
        if (this.height % 256 == 255) {
            ++nResponseSize;
        }
        if (this.height / 256 == 255) {
            ++nResponseSize;
        }
        int[] response = new int[nResponseSize];
        response[0] = 31;
        int nIndex = 1;
        int nShift = 24;
        while (nIndex < nResponseSize) {
            int nTurnedOnBits = 255;
            response[nIndex] = (nCompoundWindowSize & (nTurnedOnBits <<= nShift)) >>> nShift;
            if (response[nIndex] == 255) {
                response[++nIndex] = 255;
            }
            ++nIndex;
            nShift -= 8;
        }
        return response;
    }
}

