/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.ApplicationInfo;
import org.apache.celeborn.common.meta.ApplicationMeta;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.WorkerEventInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.network.CelebornRackResolver;
import org.apache.celeborn.common.protocol.PbApplicationInfo;
import org.apache.celeborn.common.protocol.PbApplicationMeta;
import org.apache.celeborn.common.protocol.PbSnapshotMetaInfo;
import org.apache.celeborn.common.protocol.PbWorkerEventInfo;
import org.apache.celeborn.common.protocol.PbWorkerStatus;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.common.util.WorkerStatusUtils;
import org.apache.celeborn.service.deploy.master.clustermeta.IMetadataHandler;
import org.apache.celeborn.service.deploy.master.clustermeta.ResourceProtos;
import org.apache.hadoop.net.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;

public abstract class AbstractMetaManager
implements IMetadataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMetaManager.class);
    public final Map<String, Set<Integer>> registeredAppAndShuffles = JavaUtils.newConcurrentHashMap();
    public final Set<String> hostnameSet = ConcurrentHashMap.newKeySet();
    public final Map<String, WorkerInfo> workersMap = JavaUtils.newConcurrentHashMap();
    public final Set<WorkerInfo> availableWorkers = ConcurrentHashMap.newKeySet();
    public final ConcurrentHashMap<WorkerInfo, Long> lostWorkers = JavaUtils.newConcurrentHashMap();
    public final ConcurrentHashMap<WorkerInfo, WorkerEventInfo> workerEventInfos = JavaUtils.newConcurrentHashMap();
    public final ConcurrentHashMap<String, Long> appHeartbeatTime = JavaUtils.newConcurrentHashMap();
    public final Set<WorkerInfo> excludedWorkers = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> manuallyExcludedWorkers = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> shutdownWorkers = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> decommissionWorkers = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> workerLostEvents = ConcurrentHashMap.newKeySet();
    protected RpcEnv rpcEnv;
    protected CelebornConf conf;
    protected CelebornRackResolver rackResolver;
    public long initialEstimatedPartitionSize;
    public long estimatedPartitionSize;
    public double unhealthyDiskRatioThreshold;
    public final LongAdder partitionTotalWritten = new LongAdder();
    public final LongAdder partitionTotalFileCount = new LongAdder();
    public final LongAdder shuffleTotalCount = new LongAdder();
    public final LongAdder applicationTotalCount = new LongAdder();
    public final Map<String, Long> shuffleFallbackCounts = JavaUtils.newConcurrentHashMap();
    public final Map<String, Long> applicationFallbackCounts = JavaUtils.newConcurrentHashMap();
    public final ConcurrentHashMap<String, ApplicationInfo> applicationInfos = JavaUtils.newConcurrentHashMap();
    public final ConcurrentHashMap<String, ApplicationMeta> applicationMetas = JavaUtils.newConcurrentHashMap();

    public void updateApplicationInfo(String appId, UserIdentifier userIdentifier, Map<String, String> extraInfo) {
        this.applicationInfos.putIfAbsent(appId, new ApplicationInfo(appId, userIdentifier, extraInfo, System.currentTimeMillis()));
    }

    public void updateRequestSlotsMeta(String shuffleKey, String hostName, Map<String, Map<String, Integer>> workerWithAllocations) {
        Tuple2 appIdShuffleId = Utils.splitShuffleKey((String)shuffleKey);
        this.registeredAppAndShuffles.computeIfAbsent((String)appIdShuffleId._1(), v -> new HashSet()).add((Integer)appIdShuffleId._2);
        String appId = (String)appIdShuffleId._1;
        this.appHeartbeatTime.compute(appId, (applicationId, oldTimestamp) -> {
            long oldTime = System.currentTimeMillis();
            if (oldTimestamp != null) {
                oldTime = oldTimestamp;
            }
            return Math.max(System.currentTimeMillis(), oldTime);
        });
        if (hostName != null) {
            this.hostnameSet.add(hostName);
        }
    }

    public void updateUnregisterShuffleMeta(String shuffleKey) {
        Tuple2 appIdShuffleId = Utils.splitShuffleKey((String)shuffleKey);
        Set<Integer> shuffleIds = this.registeredAppAndShuffles.get(appIdShuffleId._1());
        if (shuffleIds != null) {
            shuffleIds.remove(appIdShuffleId._2);
            this.registeredAppAndShuffles.compute((String)appIdShuffleId._1(), (s, shuffles) -> {
                if (shuffles.size() == 0) {
                    return null;
                }
                return shuffles;
            });
        }
    }

    public void updateBatchUnregisterShuffleMeta(List<String> shuffleKeys) {
        for (String shuffleKey : shuffleKeys) {
            Tuple2 appIdShuffleId = Utils.splitShuffleKey((String)shuffleKey);
            String appId = (String)appIdShuffleId._1;
            if (!this.registeredAppAndShuffles.containsKey(appId)) continue;
            this.registeredAppAndShuffles.get(appId).remove(appIdShuffleId._2);
        }
    }

    public void updateAppHeartbeatMeta(String appId, long time, long totalWritten, long fileCount, long shuffleCount, long applicationCount, Map<String, Long> shuffleFallbackCounts, Map<String, Long> applicationFallbackCounts) {
        this.appHeartbeatTime.put(appId, time);
        this.partitionTotalWritten.add(totalWritten);
        this.partitionTotalFileCount.add(fileCount);
        this.shuffleTotalCount.add(shuffleCount);
        this.applicationTotalCount.add(applicationCount);
        this.addFallbackCounts(this.shuffleFallbackCounts, shuffleFallbackCounts);
        this.addFallbackCounts(this.applicationFallbackCounts, applicationFallbackCounts);
    }

    public void updateAppLostMeta(String appId) {
        this.registeredAppAndShuffles.remove(appId);
        this.appHeartbeatTime.remove(appId);
        this.applicationMetas.remove(appId);
        this.applicationInfos.remove(appId);
    }

    @VisibleForTesting
    public void updateExcludedWorkersMeta(List<WorkerInfo> workersToAdd, List<WorkerInfo> workersToRemove) {
        workersToAdd.forEach(worker -> {
            this.excludedWorkers.add((WorkerInfo)worker);
            this.availableWorkers.remove(worker);
        });
        workersToRemove.forEach(worker -> {
            this.excludedWorkers.remove(worker);
            this.updateAvailableWorkers((WorkerInfo)worker);
        });
    }

    public void updateManuallyExcludedWorkersMeta(List<WorkerInfo> workersToAdd, List<WorkerInfo> workersToRemove) {
        workersToAdd.forEach(worker -> {
            this.manuallyExcludedWorkers.add((WorkerInfo)worker);
            this.availableWorkers.remove(worker);
        });
        workersToRemove.forEach(worker -> {
            this.manuallyExcludedWorkers.remove(worker);
            this.updateAvailableWorkers((WorkerInfo)worker);
        });
    }

    public void reviseLostShuffles(String appId, List<Integer> lostShuffles) {
        this.registeredAppAndShuffles.computeIfAbsent(appId, v -> new HashSet()).addAll(lostShuffles);
    }

    public void deleteApp(String appId) {
        this.registeredAppAndShuffles.remove(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerLostMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort);
        this.workerLostEvents.add(worker);
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            this.workersMap.remove(worker.toUniqueId());
            this.lostWorkers.put(worker, System.currentTimeMillis());
            this.availableWorkers.remove(worker);
        }
        this.excludedWorkers.remove(worker);
        this.workerLostEvents.remove(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerRemoveMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort);
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            this.workersMap.remove(worker.toUniqueId());
            this.lostWorkers.put(worker, System.currentTimeMillis());
            this.availableWorkers.remove(worker);
        }
        this.excludedWorkers.remove(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkersUnavailableInfoMeta(List<WorkerInfo> unavailableWorkers) {
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            for (WorkerInfo workerInfo : unavailableWorkers) {
                if (!this.lostWorkers.containsKey(workerInfo)) continue;
                this.lostWorkers.remove(workerInfo);
                this.shutdownWorkers.remove(workerInfo);
                this.workerEventInfos.remove(workerInfo);
                this.decommissionWorkers.remove(workerInfo);
                this.updateAvailableWorkers(workerInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerHeartbeatMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<String, DiskInfo> disks, long time, WorkerStatus workerStatus, boolean highWorkload) {
        long unhealthyDiskNum;
        boolean exceed;
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, -1, disks, null);
        AtomicLong availableSlots = new AtomicLong();
        LOG.debug("update worker {}:{} heartbeat {}", new Object[]{host, rpcPort, disks});
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            Optional<WorkerInfo> workerInfo = Optional.ofNullable(this.workersMap.get(worker.toUniqueId()));
            workerInfo.ifPresent(info -> {
                info.updateThenGetDiskInfos(disks, Option.apply((Object)this.estimatedPartitionSize));
                availableSlots.set(info.totalAvailableSlots());
                info.lastHeartbeat_$eq(time);
                info.setWorkerStatus(workerStatus);
            });
        }
        WorkerEventInfo workerEventInfo = this.workerEventInfos.get(worker);
        if (workerEventInfo != null && WorkerStatusUtils.meetFinalState((WorkerEventInfo)workerEventInfo, (WorkerStatus)workerStatus)) {
            this.workerEventInfos.remove(worker);
            if (workerStatus.getState() == PbWorkerStatus.State.Normal) {
                this.shutdownWorkers.remove(worker);
            }
        }
        boolean bl = exceed = (double)(unhealthyDiskNum = disks.values().stream().filter(s -> !s.status().equals((Object)DiskStatus.HEALTHY)).count()) * 1.0 / (double)disks.size() >= this.unhealthyDiskRatioThreshold;
        if (!(this.excludedWorkers.contains(worker) || (!disks.isEmpty() && !exceed || this.conf.hasHDFSStorage() || this.conf.hasS3Storage() || this.conf.hasOssStorage()) && !highWorkload)) {
            LOG.warn("Worker {} (unhealthy disks num: {}, high workload: {}) adds to excluded workers", new Object[]{worker, unhealthyDiskNum, highWorkload});
            this.excludedWorkers.add(worker);
        } else if ((availableSlots.get() > 0L || this.conf.hasHDFSStorage() || this.conf.hasS3Storage() || this.conf.hasOssStorage()) && !highWorkload) {
            this.excludedWorkers.remove(worker);
        }
        if (workerStatus.getState() == PbWorkerStatus.State.Normal) {
            this.updateAvailableWorkers(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegisterWorkerMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort, String networkLocation, Map<String, DiskInfo> disks) {
        WorkerInfo workerInfo = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, internalPort, disks, new HashMap());
        workerInfo.lastHeartbeat_$eq(System.currentTimeMillis());
        if (networkLocation != null && !networkLocation.isEmpty() && !"/default-rack".equals(networkLocation)) {
            workerInfo.networkLocation_$eq(networkLocation);
        } else {
            workerInfo.networkLocation_$eq(this.rackResolver.resolve(host).getNetworkLocation());
        }
        workerInfo.updateDiskSlots(this.estimatedPartitionSize);
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            this.workersMap.putIfAbsent(workerInfo.toUniqueId(), workerInfo);
            this.shutdownWorkers.remove(workerInfo);
            this.lostWorkers.remove(workerInfo);
            this.excludedWorkers.remove(workerInfo);
            this.workerEventInfos.remove(workerInfo);
            this.decommissionWorkers.remove(workerInfo);
            this.updateAvailableWorkers(workerInfo);
        }
    }

    public void writeMetaInfoToFile(File file) throws IOException, RuntimeException {
        byte[] snapshotBytes = PbSerDeUtils.toPbSnapshotMetaInfo((Long)this.estimatedPartitionSize, this.registeredAppAndShuffles, this.hostnameSet, this.excludedWorkers, this.manuallyExcludedWorkers, this.workerLostEvents, this.appHeartbeatTime, new HashSet<WorkerInfo>(this.workersMap.values()), (Long)this.partitionTotalWritten.sum(), (Long)this.partitionTotalFileCount.sum(), (Long)this.shuffleTotalCount.sum(), (Long)this.applicationTotalCount.sum(), this.shuffleFallbackCounts, this.applicationFallbackCounts, this.lostWorkers, this.shutdownWorkers, this.workerEventInfos, this.applicationMetas, this.applicationInfos, this.decommissionWorkers).toByteArray();
        Files.write(file.toPath(), snapshotBytes, new OpenOption[0]);
    }

    public void restoreMetaFromFile(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            PbSnapshotMetaInfo snapshotMetaInfo = PbSnapshotMetaInfo.parseFrom((InputStream)in);
            this.cleanUpState();
            this.estimatedPartitionSize = snapshotMetaInfo.getEstimatedPartitionSize();
            for (String shuffleKey : snapshotMetaInfo.getRegisteredShuffleList()) {
                Tuple2 appIdShuffleId = Utils.splitShuffleKey((String)shuffleKey);
                this.registeredAppAndShuffles.computeIfAbsent((String)appIdShuffleId._1, v -> new HashSet()).add((Integer)appIdShuffleId._2);
            }
            this.hostnameSet.addAll((Collection<String>)snapshotMetaInfo.getHostnameSetList());
            this.excludedWorkers.addAll(snapshotMetaInfo.getExcludedWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.manuallyExcludedWorkers.addAll(snapshotMetaInfo.getManuallyExcludedWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.workerLostEvents.addAll(snapshotMetaInfo.getWorkerLostEventsList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.appHeartbeatTime.putAll(snapshotMetaInfo.getAppHeartbeatTimeMap());
            this.registeredAppAndShuffles.forEach((appId, shuffleId) -> {
                if (!this.appHeartbeatTime.containsKey(appId)) {
                    this.appHeartbeatTime.put((String)appId, System.currentTimeMillis());
                }
            });
            Set workerInfoSet = snapshotMetaInfo.getWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet());
            List workerHostList = workerInfoSet.stream().filter(w -> "/default-rack".equals(w.networkLocation())).map(WorkerInfo::host).collect(Collectors.toList());
            scala.collection.immutable.Map resolveMap = this.rackResolver.resolveToMap(workerHostList);
            this.workersMap.putAll(workerInfoSet.stream().peek(workerInfo -> {
                if ("/default-rack".equals(workerInfo.networkLocation())) {
                    workerInfo.networkLocation_$eq(((Node)resolveMap.get((Object)workerInfo.host()).get()).getNetworkLocation());
                }
            }).collect(Collectors.toMap(WorkerInfo::toUniqueId, w -> w)));
            snapshotMetaInfo.getLostWorkersMap().forEach((key, value) -> this.lostWorkers.put(WorkerInfo.fromUniqueId((String)key), (Long)value));
            snapshotMetaInfo.getWorkerEventInfosMap().entrySet().forEach(entry -> this.workerEventInfos.put(WorkerInfo.fromUniqueId((String)((String)entry.getKey())), PbSerDeUtils.fromPbWorkerEventInfo((PbWorkerEventInfo)((PbWorkerEventInfo)entry.getValue()))));
            this.shutdownWorkers.addAll(snapshotMetaInfo.getShutdownWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.decommissionWorkers.addAll(snapshotMetaInfo.getDecommissionWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.partitionTotalWritten.add(snapshotMetaInfo.getPartitionTotalWritten());
            this.partitionTotalFileCount.add(snapshotMetaInfo.getPartitionTotalFileCount());
            this.shuffleTotalCount.add(snapshotMetaInfo.getShuffleTotalCount());
            this.applicationTotalCount.add(snapshotMetaInfo.getApplicationTotalCount());
            this.addFallbackCounts(this.shuffleFallbackCounts, snapshotMetaInfo.getShuffleFallbackCountsMap());
            this.addFallbackCounts(this.applicationFallbackCounts, snapshotMetaInfo.getApplicationFallbackCountsMap());
            snapshotMetaInfo.getApplicationMetasMap().forEach((key, value) -> this.applicationMetas.put((String)key, PbSerDeUtils.fromPbApplicationMeta((PbApplicationMeta)value)));
            snapshotMetaInfo.getApplicationInfosMap().forEach((key, value) -> this.applicationInfos.put((String)key, PbSerDeUtils.fromPbApplicationInfo((PbApplicationInfo)value)));
            this.availableWorkers.addAll(this.workersMap.values().stream().filter(worker -> this.isWorkerAvailable((WorkerInfo)worker)).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        LOG.info("Successfully restore meta info from snapshot {}", (Object)file.getAbsolutePath());
        LOG.info("Worker size: {}, Registered shuffle size: {}. Worker excluded list size: {}. Manually Excluded list size: {}", new Object[]{this.workersMap.size(), this.registeredAppAndShuffles.size(), this.excludedWorkers.size(), this.manuallyExcludedWorkers.size()});
        this.workersMap.values().forEach(workerInfo -> LOG.info(workerInfo.toString()));
        this.registeredAppAndShuffles.forEach((appId, shuffleId) -> LOG.info("RegisteredShuffle {}-{}", appId, shuffleId));
    }

    private void cleanUpState() {
        this.registeredAppAndShuffles.clear();
        this.hostnameSet.clear();
        this.workersMap.clear();
        this.availableWorkers.clear();
        this.lostWorkers.clear();
        this.appHeartbeatTime.clear();
        this.excludedWorkers.clear();
        this.shutdownWorkers.clear();
        this.decommissionWorkers.clear();
        this.manuallyExcludedWorkers.clear();
        this.workerLostEvents.clear();
        this.partitionTotalWritten.reset();
        this.partitionTotalFileCount.reset();
        this.shuffleTotalCount.reset();
        this.applicationTotalCount.reset();
        this.shuffleFallbackCounts.clear();
        this.applicationFallbackCounts.clear();
        this.workerEventInfos.clear();
        this.applicationMetas.clear();
        this.applicationInfos.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaByReportWorkerUnavailable(List<WorkerInfo> failedWorkers) {
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            this.shutdownWorkers.addAll(failedWorkers);
            this.availableWorkers.removeAll(failedWorkers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerEventMeta(int workerEventTypeValue, List<WorkerInfo> workerInfoList) {
        long eventTime = System.currentTimeMillis();
        ResourceProtos.WorkerEventType eventType = ResourceProtos.WorkerEventType.forNumber(workerEventTypeValue);
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            for (WorkerInfo workerInfo : workerInfoList) {
                WorkerEventInfo workerEventInfo = this.workerEventInfos.get(workerInfo);
                LOG.info("Received worker event: {} for worker: {}", (Object)eventType, (Object)workerInfo.toUniqueId());
                if (workerEventInfo != null && workerEventInfo.isSameEvent(eventType.getNumber())) continue;
                if (eventType == ResourceProtos.WorkerEventType.None) {
                    this.workerEventInfos.remove(workerInfo);
                    this.updateAvailableWorkers(workerInfo);
                    continue;
                }
                this.workerEventInfos.put(workerInfo, new WorkerEventInfo(eventType.getNumber(), eventTime));
                this.availableWorkers.remove(workerInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaByReportWorkerDecommission(List<WorkerInfo> workers) {
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            this.decommissionWorkers.addAll(workers);
            this.availableWorkers.removeAll(workers);
        }
    }

    public void updatePartitionSize() {
        long oldEstimatedPartitionSize = this.estimatedPartitionSize;
        long tmpTotalWritten = this.partitionTotalWritten.sumThenReset();
        long tmpFileCount = this.partitionTotalFileCount.sumThenReset();
        LOG.debug("update partition size total written {}, file count {}", (Object)Utils.bytesToString((long)tmpTotalWritten), (Object)tmpFileCount);
        this.estimatedPartitionSize = tmpFileCount != 0L ? Math.max(this.conf.minPartitionSizeToEstimate(), Math.min(tmpTotalWritten / tmpFileCount, this.conf.maxPartitionSizeToEstimate())) : this.initialEstimatedPartitionSize;
        if (this.estimatedPartitionSize == oldEstimatedPartitionSize) {
            return;
        }
        LOG.warn("Celeborn cluster estimated partition size changed from {} to {}", (Object)Utils.bytesToString((long)oldEstimatedPartitionSize), (Object)Utils.bytesToString((long)this.estimatedPartitionSize));
        HashSet<WorkerInfo> workers = new HashSet<WorkerInfo>(this.workersMap.values());
        this.excludedWorkers.forEach(workers::remove);
        this.manuallyExcludedWorkers.forEach(workers::remove);
        workers.forEach(workerInfo -> workerInfo.updateDiskSlots(this.estimatedPartitionSize));
    }

    private boolean isWorkerAvailable(WorkerInfo workerInfo) {
        return workerInfo.getWorkerStatus().getState() == PbWorkerStatus.State.Normal && !this.workerEventInfos.containsKey(workerInfo) && !this.excludedWorkers.contains(workerInfo) && !this.shutdownWorkers.contains(workerInfo) && !this.manuallyExcludedWorkers.contains(workerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAvailableWorkers(WorkerInfo worker) {
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            Optional<WorkerInfo> workerInfo = Optional.ofNullable(this.workersMap.get(worker.toUniqueId()));
            if (workerInfo.map(this::isWorkerAvailable).orElse(false).booleanValue()) {
                this.availableWorkers.add(workerInfo.get());
            } else {
                this.availableWorkers.remove(worker);
            }
        }
    }

    public void updateApplicationMeta(ApplicationMeta applicationMeta) {
        this.applicationMetas.putIfAbsent(applicationMeta.appId(), applicationMeta);
    }

    public void removeApplicationMeta(String appId) {
        this.applicationMetas.remove(appId);
    }

    public int registeredShuffleCount() {
        return this.registeredAppAndShuffles.values().stream().mapToInt(Set::size).sum();
    }

    private void addFallbackCounts(Map<String, Long> fallbackCounts, Map<String, Long> counts) {
        for (String fallbackPolicy : counts.keySet()) {
            fallbackCounts.compute(fallbackPolicy, (k, v) -> v == null ? (Long)counts.get(k) : Long.valueOf(v + (Long)counts.get(k)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerResourceConsumptions(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<UserIdentifier, ResourceConsumption> resourceConsumptions) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, -1, null, null);
        Map<String, WorkerInfo> map = this.workersMap;
        synchronized (map) {
            Optional<WorkerInfo> workerInfo = Optional.ofNullable(this.workersMap.get(worker.toUniqueId()));
            workerInfo.ifPresent(info -> info.updateThenGetUserResourceConsumption(resourceConsumptions));
        }
    }
}

