/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.commit;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.celeborn.client.commit.AbstractPartitionCompletenessValidator;
import org.apache.celeborn.common.CommitMetadata;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005M4A!\u0004\b\u00013!)a\u0004\u0001C\u0001?!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u001f\u0001A\u0003%1\u0005C\u0004?\u0001\t\u0007I\u0011B \t\r\u0005\u0003\u0001\u0015!\u0003A\u0011\u001d\u0011\u0005A1A\u0005\n\rCa!\u0012\u0001!\u0002\u0013!\u0005\"\u0002$\u0001\t\u0003:\u0005\"B2\u0001\t\u0013!\u0007\"\u00026\u0001\t\u0013Y\u0007\"B7\u0001\t\u0003r\u0007\"\u00029\u0001\t\u0003\n(\u0001J*lK^D\u0015M\u001c3mS:<w+\u001b;i_V$X*\u00199SC:<WMV1mS\u0012\fGo\u001c:\u000b\u0005=\u0001\u0012AB2p[6LGO\u0003\u0002\u0012%\u000511\r\\5f]RT!a\u0005\u000b\u0002\u0011\r,G.\u001a2pe:T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011C\u0001\u0001\u001b!\tYB$D\u0001\u000f\u0013\tibB\u0001\u0014BEN$(/Y2u!\u0006\u0014H/\u001b;j_:\u001cu.\u001c9mKR,g.Z:t-\u0006d\u0017\u000eZ1u_J\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005m\u0001\u0011a\u0007;pi\u0006d7+\u001e2QCJ$\u0018\u000e^5p]N\u0004&o\\2fgN,G-F\u0001$!\u0011!3&L\u001a\u000e\u0003\u0015R!AJ\u0014\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002)S\u0005!Q\u000f^5m\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0013\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tFA\u0002J]R\u0004B\u0001N\u001b.o5\tq%\u0003\u00027O\t9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0013\u0003\u0019\u0019w.\\7p]&\u0011A(\u000f\u0002\u000f\u0007>lW.\u001b;NKR\fG-\u0019;b\u0003q!x\u000e^1m'V\u0014\u0007+\u0019:uSRLwN\\:Qe>\u001cWm]:fI\u0002\nA\u0004]1si&$\u0018n\u001c8U_N+(\rU1si&$\u0018n\u001c8D_VtG/F\u0001A!\u0011!3&L\u0017\u0002;A\f'\u000f^5uS>tGk\\*vEB\u000b'\u000f^5uS>t7i\\;oi\u0002\nqdY;se\u0016tGoQ8n[&$X*\u001a;bI\u0006$\u0018MR8s%\u0016$WoY3s+\u0005!\u0005\u0003\u0002\u0013,[]\n\u0001eY;se\u0016tGoQ8n[&$X*\u001a;bI\u0006$\u0018MR8s%\u0016$WoY3sA\u0005\u0019\u0002O]8dKN\u001c8+\u001e2QCJ$\u0018\u000e^5p]R1\u0001*W.^?\u0006\u0004BAL%L\u001d&\u0011!j\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00059b\u0015BA'0\u0005\u001d\u0011un\u001c7fC:\u0004\"a\u0014,\u000f\u0005A#\u0006CA)0\u001b\u0005\u0011&BA*\u0019\u0003\u0019a$o\\8u}%\u0011QkL\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V_!)!\f\u0003a\u0001[\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u0015a\u0006\u00021\u0001.\u00035\u0019H/\u0019:u\u001b\u0006\u0004\u0018J\u001c3fq\")a\f\u0003a\u0001[\u0005YQM\u001c3NCBLe\u000eZ3y\u0011\u0015\u0001\u0007\u00021\u00018\u0003Q\t7\r^;bY\u000e{W.\\5u\u001b\u0016$\u0018\rZ1uC\")!\r\u0003a\u0001[\u0005AR\r\u001f9fGR,G\rV8uC2l\u0015\r\u001d9fe\u000e{WO\u001c;\u0002)U\u0004H-\u0019;f\u0007>lW.\u001b;NKR\fG-\u0019;b)\r)\u0007.\u001b\t\u0003]\u0019L!aZ\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u00065&\u0001\r!\f\u0005\u0006A&\u0001\raN\u0001'O\u0016$Hk\u001c;bY:+XNY3s\u001f\u001a\u001cVO\u0019)beRLG/[8ogB\u0013xnY3tg\u0016$GCA\u0017m\u0011\u0015Q&\u00021\u0001.\u0003U\u0019WO\u001d:f]R\u001cu.\\7ji6+G/\u00193bi\u0006$\"aN8\t\u000bi[\u0001\u0019A\u0017\u0002'%\u001c\b+\u0019:uSRLwN\\\"p[BdW\r^3\u0015\u0005-\u0013\b\"\u0002.\r\u0001\u0004i\u0003")
public class SkewHandlingWithoutMapRangeValidator
extends AbstractPartitionCompletenessValidator {
    private final ConcurrentHashMap<Object, HashMap<Object, CommitMetadata>> totalSubPartitionsProcessed = JavaUtils.newConcurrentHashMap();
    private final ConcurrentHashMap<Object, Object> partitionToSubPartitionCount = JavaUtils.newConcurrentHashMap();
    private final ConcurrentHashMap<Object, CommitMetadata> currentCommitMetadataForReducer = JavaUtils.newConcurrentHashMap();

    private ConcurrentHashMap<Object, HashMap<Object, CommitMetadata>> totalSubPartitionsProcessed() {
        return this.totalSubPartitionsProcessed;
    }

    private ConcurrentHashMap<Object, Object> partitionToSubPartitionCount() {
        return this.partitionToSubPartitionCount;
    }

    private ConcurrentHashMap<Object, CommitMetadata> currentCommitMetadataForReducer() {
        return this.currentCommitMetadataForReducer;
    }

    @Override
    public Tuple2<Object, String> processSubPartition(int partitionId, int startMapIndex, int endMapIndex, CommitMetadata actualCommitMetadata, int expectedTotalMapperCount) {
        block7: {
            Preconditions.checkArgument(endMapIndex >= 0, "index of sub-partition %s must be greater than or equal to 0", endMapIndex);
            Preconditions.checkArgument(startMapIndex > endMapIndex, "startMapIndex %s must be greater than endMapIndex %s", startMapIndex, endMapIndex);
            ConcurrentHashMap<Object, HashMap<Object, CommitMetadata>> concurrentHashMap = this.totalSubPartitionsProcessed();
            synchronized (concurrentHashMap) {
                Tuple2 tuple2;
                block6: {
                    Object object;
                    if (this.totalSubPartitionsProcessed().containsKey(BoxesRunTime.boxToInteger((int)partitionId))) {
                        int currentSubPartitionCount = BoxesRunTime.unboxToInt((Object)this.partitionToSubPartitionCount().getOrDefault(BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)-1)));
                        Preconditions.checkState(currentSubPartitionCount == startMapIndex, "total subpartition count mismatch for partitionId %s existing %s new %s", (Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToInteger((int)currentSubPartitionCount), (Object)BoxesRunTime.boxToInteger((int)startMapIndex));
                        object = BoxedUnit.UNIT;
                    } else {
                        this.totalSubPartitionsProcessed().put(BoxesRunTime.boxToInteger((int)partitionId), new HashMap());
                        object = this.partitionToSubPartitionCount().put(BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)startMapIndex));
                    }
                    HashMap<Object, CommitMetadata> subPartitionsProcessed = this.totalSubPartitionsProcessed().get(BoxesRunTime.boxToInteger((int)partitionId));
                    if (subPartitionsProcessed.containsKey(BoxesRunTime.boxToInteger((int)endMapIndex))) {
                        CommitMetadata existingCommitMetadata;
                        CommitMetadata commitMetadata = existingCommitMetadata = subPartitionsProcessed.get(BoxesRunTime.boxToInteger((int)endMapIndex));
                        CommitMetadata commitMetadata2 = actualCommitMetadata;
                        tuple2 = (commitMetadata == null ? commitMetadata2 != null : !((Object)commitMetadata).equals(commitMetadata2)) ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(73).append("Mismatch in metadata for the same chunk range on retry: ").append(endMapIndex).append(" existing: ").append(existingCommitMetadata).append(" new: ").append(actualCommitMetadata).toString()) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
                        break block6;
                    }
                    this.updateCommitMetadata(partitionId, actualCommitMetadata);
                    subPartitionsProcessed.put(BoxesRunTime.boxToInteger((int)endMapIndex), actualCommitMetadata);
                    int partitionProcessed = this.getTotalNumberOfSubPartitionsProcessed(partitionId);
                    Preconditions.checkState(partitionProcessed <= startMapIndex, "Number of sub-partitions processed %s should less than total number of sub-partitions %s", partitionProcessed, startMapIndex);
                    break block7;
                }
                return tuple2;
            }
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    private void updateCommitMetadata(int partitionId, CommitMetadata actualCommitMetadata) {
        CommitMetadata currentCommitMetadata = this.currentCommitMetadataForReducer().computeIfAbsent(BoxesRunTime.boxToInteger((int)partitionId), new Function<Object, CommitMetadata>(null){

            public <V> Function<V, CommitMetadata> compose(Function<? super V, ? extends Object> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Object, V> andThen(Function<? super CommitMetadata, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public CommitMetadata apply(int partitionId) {
                return new CommitMetadata();
            }
        });
        currentCommitMetadata.addCommitData(actualCommitMetadata);
    }

    private int getTotalNumberOfSubPartitionsProcessed(int partitionId) {
        return this.totalSubPartitionsProcessed().get(BoxesRunTime.boxToInteger((int)partitionId)).size();
    }

    @Override
    public CommitMetadata currentCommitMetadata(int partitionId) {
        return this.currentCommitMetadataForReducer().get(BoxesRunTime.boxToInteger((int)partitionId));
    }

    @Override
    public boolean isPartitionComplete(int partitionId) {
        return this.getTotalNumberOfSubPartitionsProcessed(partitionId) == BoxesRunTime.unboxToInt((Object)this.partitionToSubPartitionCount().get(BoxesRunTime.boxToInteger((int)partitionId)));
    }
}

