/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.RemoteShuffleDescriptor;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.metrics.groups.ShuffleIOMetricGroup;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteShuffleResultPartitionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteShuffleResultPartitionFactory.class);
    public static final int MIN_BUFFERS_PER_PARTITION = 16;
    protected final ResultPartitionManager partitionManager;
    protected final BufferPoolFactory bufferPoolFactory;
    protected final int networkBufferSize;
    protected final int numBuffersPerPartition;
    protected boolean supportFloatingBuffers;
    protected String compressionCodec;

    public AbstractRemoteShuffleResultPartitionFactory(CelebornConf celebornConf, ResultPartitionManager partitionManager, BufferPoolFactory bufferPoolFactory, int networkBufferSize) {
        this.numBuffersPerPartition = Utils.checkedDownCast(celebornConf.clientFlinkMemoryPerResultPartition() / (long)networkBufferSize);
        if (this.numBuffersPerPartition < 16) {
            throw new IllegalArgumentException(String.format("Insufficient network memory per partition, please increase %s to at least %d bytes.", CelebornConf.CLIENT_MEMORY_PER_RESULT_PARTITION().key(), networkBufferSize * 16));
        }
        this.supportFloatingBuffers = celebornConf.clientFlinkResultPartitionSupportFloatingBuffer();
        this.partitionManager = partitionManager;
        this.bufferPoolFactory = bufferPoolFactory;
        this.networkBufferSize = networkBufferSize;
        this.compressionCodec = celebornConf.shuffleCompressionCodec().name();
    }

    public ResultPartition create(String taskNameWithSubtaskAndId, int partitionIndex, ResultPartitionDeploymentDescriptor desc, CelebornConf celebornConf, ShuffleIOMetricGroup shuffleIOMetricGroup) {
        LOG.info("Create result partition -- number of buffers per result partition={}, number of subpartitions={}.", (Object)this.numBuffersPerPartition, (Object)desc.getNumberOfSubpartitions());
        return this.create(taskNameWithSubtaskAndId, partitionIndex, desc.getShuffleDescriptor().getResultPartitionID(), desc.getPartitionType(), desc.getNumberOfSubpartitions(), desc.getMaxParallelism(), this.createBufferPoolFactory(), (RemoteShuffleDescriptor)desc.getShuffleDescriptor(), celebornConf, desc.getTotalNumberOfPartitions(), shuffleIOMetricGroup);
    }

    public ResultPartition create(String taskNameWithSubtaskAndId, int partitionIndex, ResultPartitionID id, ResultPartitionType type, int numSubpartitions, int maxParallelism, List<SupplierWithException<BufferPool, IOException>> bufferPoolFactories, RemoteShuffleDescriptor shuffleDescriptor, CelebornConf celebornConf, int numMappers, ShuffleIOMetricGroup shuffleIOMetricGroup) {
        ResultPartition partition = this.createRemoteShuffleResultPartitionInternal(taskNameWithSubtaskAndId, partitionIndex, id, type, numSubpartitions, maxParallelism, bufferPoolFactories, celebornConf, numMappers, this.getBufferCompressor(), shuffleDescriptor, shuffleIOMetricGroup);
        LOG.debug("{}: Initialized {}", (Object)taskNameWithSubtaskAndId, (Object)this);
        return partition;
    }

    abstract ResultPartition createRemoteShuffleResultPartitionInternal(String var1, int var2, ResultPartitionID var3, ResultPartitionType var4, int var5, int var6, List<SupplierWithException<BufferPool, IOException>> var7, CelebornConf var8, int var9, BufferCompressor var10, RemoteShuffleDescriptor var11, ShuffleIOMetricGroup var12);

    private List<SupplierWithException<BufferPool, IOException>> createBufferPoolFactory() {
        int numForResultPartition = this.numBuffersPerPartition * 7 / 8;
        int numForOutputGate = this.numBuffersPerPartition - numForResultPartition;
        ArrayList<SupplierWithException<BufferPool, IOException>> factories = new ArrayList<SupplierWithException<BufferPool, IOException>>();
        if (this.supportFloatingBuffers) {
            factories.add(() -> this.bufferPoolFactory.createBufferPool(2, numForResultPartition));
            factories.add(() -> this.bufferPoolFactory.createBufferPool(2, numForOutputGate));
        } else {
            factories.add(() -> this.bufferPoolFactory.createBufferPool(numForResultPartition, numForResultPartition));
            factories.add(() -> this.bufferPoolFactory.createBufferPool(numForOutputGate, numForOutputGate));
        }
        return factories;
    }

    @VisibleForTesting
    int getNetworkBufferSize() {
        return this.networkBufferSize;
    }

    @VisibleForTesting
    protected abstract BufferCompressor getBufferCompressor();
}

