/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.impl;

import java.util.function.Function;
import o.a.c.sidecar.client.shaded.io.vertx.core.Closeable;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.CloseFuture;
import o.a.c.sidecar.client.shaded.io.vertx.core.shareddata.LocalMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.shareddata.Shareable;

class SharedClientHolder<C>
implements Shareable {
    final Hook<C> hook;
    final int count;
    final C client;

    static <C> C createSharedClient(Vertx vertx, String clientKey, String clientName, CloseFuture closeFuture, Function<CloseFuture, C> supplier) {
        LocalMap<String, SharedClientHolder> localMap = vertx.sharedData().getLocalMap(clientKey);
        SharedClientHolder v = localMap.compute(clientName, (key, value) -> {
            if (value == null) {
                Hook hook = new Hook(vertx, clientKey, clientName);
                Object client = supplier.apply(hook.closeFuture);
                return new SharedClientHolder(hook, 1, client);
            }
            return new SharedClientHolder(value.hook, value.count + 1, value.client);
        });
        C client = v.client;
        closeFuture.add(v.hook);
        return client;
    }

    SharedClientHolder(Hook<C> hook, int count, C client) {
        this.hook = hook;
        this.count = count;
        this.client = client;
    }

    private static class Hook<C>
    implements Closeable {
        private final Vertx vertx;
        private final CloseFuture closeFuture;
        private final String clientKey;
        private final String clientName;

        private Hook(Vertx vertx, String clientKey, String clientName) {
            this.vertx = vertx;
            this.closeFuture = new CloseFuture();
            this.clientKey = clientKey;
            this.clientName = clientName;
        }

        @Override
        public void close(Promise<Void> completion) {
            LocalMap<String, SharedClientHolder> localMap1 = this.vertx.sharedData().getLocalMap(this.clientKey);
            SharedClientHolder res = localMap1.compute(this.clientName, (key, value) -> {
                if (value == null) {
                    return null;
                }
                if (value.count == 1) {
                    return null;
                }
                return new SharedClientHolder(this, value.count - 1, value.client);
            });
            if (res == null) {
                this.closeFuture.close(completion);
            } else {
                completion.complete();
            }
        }
    }
}

