/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.common.response.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import o.a.c.sidecar.client.shaded.common.DataObjectBuilder;
import o.a.c.sidecar.client.shaded.common.data.ConsistencyVerificationResult;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobSummaryResponsePayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreRangeJson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RestoreJobProgressResponsePayload {
    private final String message;
    private final ConsistencyVerificationResult status;
    private final RestoreJobSummaryResponsePayload summary;
    @Nullable
    private final List<RestoreRangeJson> failedRanges;
    @Nullable
    private final List<RestoreRangeJson> abortedRanges;
    @Nullable
    private final List<RestoreRangeJson> pendingRanges;
    @Nullable
    private final List<RestoreRangeJson> succeededRanges;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public RestoreJobProgressResponsePayload(@JsonProperty(value="message") @NotNull String message, @JsonProperty(value="status") @NotNull ConsistencyVerificationResult status, @JsonProperty(value="summary") @NotNull RestoreJobSummaryResponsePayload summary, @JsonProperty(value="failedRanges") @Nullable List<RestoreRangeJson> failedRanges, @JsonProperty(value="abortedRanges") @Nullable List<RestoreRangeJson> abortedRanges, @JsonProperty(value="pendingRanges") @Nullable List<RestoreRangeJson> pendingRanges, @JsonProperty(value="succeededRanges") @Nullable List<RestoreRangeJson> succeededRanges) {
        this.message = message;
        this.status = status;
        this.summary = summary;
        this.failedRanges = failedRanges;
        this.abortedRanges = abortedRanges;
        this.pendingRanges = pendingRanges;
        this.succeededRanges = succeededRanges;
    }

    private RestoreJobProgressResponsePayload(Builder builder) {
        this(builder.message, builder.status, builder.summary, builder.failedRanges, builder.abortedRanges, builder.pendingRanges, builder.succeededRanges);
    }

    @JsonProperty(value="message")
    @NotNull
    public String message() {
        return this.message;
    }

    @JsonProperty(value="status")
    @NotNull
    public ConsistencyVerificationResult status() {
        return this.status;
    }

    @JsonProperty(value="summary")
    @NotNull
    public RestoreJobSummaryResponsePayload summary() {
        return this.summary;
    }

    @JsonProperty(value="failedRanges")
    @Nullable
    public List<RestoreRangeJson> failedRanges() {
        return this.failedRanges;
    }

    @JsonProperty(value="abortedRanges")
    @Nullable
    public List<RestoreRangeJson> abortedRanges() {
        return this.abortedRanges;
    }

    @JsonProperty(value="pendingRanges")
    @Nullable
    public List<RestoreRangeJson> pendingRanges() {
        return this.pendingRanges;
    }

    @JsonProperty(value="succeededRanges")
    @Nullable
    public List<RestoreRangeJson> succeededRanges() {
        return this.succeededRanges;
    }

    public static class Builder
    implements DataObjectBuilder<Builder, RestoreJobProgressResponsePayload> {
        String message;
        ConsistencyVerificationResult status;
        RestoreJobSummaryResponsePayload summary;
        List<RestoreRangeJson> failedRanges = null;
        List<RestoreRangeJson> abortedRanges = null;
        List<RestoreRangeJson> pendingRanges = null;
        List<RestoreRangeJson> succeededRanges = null;

        public Builder withStatus(ConsistencyVerificationResult status) {
            return this.update(b -> {
                b.status = status;
            });
        }

        public Builder withMessage(String message) {
            return this.update(b -> {
                b.message = message;
            });
        }

        public Builder withJobSummary(String createdAt, UUID jobId, String jobAgent, String keyspace, String table, String status) {
            return this.update(b -> {
                b.summary = new RestoreJobSummaryResponsePayload(createdAt, jobId, jobAgent, keyspace, table, null, status);
            });
        }

        public Builder withFailedRanges(List<RestoreRangeJson> failedRanges) {
            return this.update(b -> {
                b.failedRanges = Builder.copyNullableList(failedRanges);
            });
        }

        public Builder withAbortedRanges(List<RestoreRangeJson> abortedRanges) {
            return this.update(b -> {
                b.abortedRanges = Builder.copyNullableList(abortedRanges);
            });
        }

        public Builder withPendingRanges(List<RestoreRangeJson> pendingRanges) {
            return this.update(b -> {
                b.pendingRanges = Builder.copyNullableList(pendingRanges);
            });
        }

        public Builder withSucceededRanges(List<RestoreRangeJson> succeededRanges) {
            return this.update(b -> {
                b.succeededRanges = Builder.copyNullableList(succeededRanges);
            });
        }

        private static List<RestoreRangeJson> copyNullableList(List<RestoreRangeJson> list) {
            return list == null ? null : new ArrayList<RestoreRangeJson>(list);
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public RestoreJobProgressResponsePayload build() {
            return new RestoreJobProgressResponsePayload(this.self());
        }
    }
}

