/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.spark.reader.ComplexTypeBuffer;
import org.apache.cassandra.spark.reader.ListBuffer;
import org.apache.cassandra.spark.reader.MapBuffer;
import org.apache.cassandra.spark.reader.SetBuffer;
import org.apache.cassandra.spark.reader.UdtBuffer;

public abstract class AbstractComplexTypeBuffer {
    protected final List<ByteBuffer> buffers;
    private final int cellCount;
    private int length = 0;

    public AbstractComplexTypeBuffer(int cellCount, int bufferSize) {
        this.cellCount = cellCount;
        this.buffers = new ArrayList<ByteBuffer>(bufferSize);
    }

    public static AbstractComplexTypeBuffer newBuffer(AbstractType<?> type, int cellCount) {
        ComplexTypeBuffer buffer;
        if (type instanceof SetType) {
            buffer = new SetBuffer(cellCount);
        } else if (type instanceof ListType) {
            buffer = new ListBuffer(cellCount);
        } else if (type instanceof MapType) {
            buffer = new MapBuffer(cellCount);
        } else if (type instanceof UserType) {
            buffer = new UdtBuffer(cellCount);
        } else {
            throw new IllegalStateException("Unexpected type deserializing CQL Collection: " + String.valueOf(type));
        }
        return buffer;
    }

    public void addCell(Cell cell) {
        this.add(cell.buffer());
    }

    void add(ByteBuffer buffer) {
        this.buffers.add(buffer);
        this.length += buffer.remaining();
    }

    ByteBuffer build() {
        ByteBuffer result = ByteBuffer.allocate(4 + this.buffers.size() * 4 + this.length);
        result.putInt(this.cellCount);
        for (ByteBuffer buffer : this.buffers) {
            result.putInt(buffer.remaining());
            result.put(buffer);
        }
        return result.flip();
    }

    public abstract ByteBuffer pack();

    protected int elements() {
        return this.buffers.size();
    }
}

