/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.spark.reader.common.BigLongArray;

final class AlignedReadonlyLongArrayMemory
extends Memory {
    private final BigLongArray array;

    AlignedReadonlyLongArrayMemory(BigLongArray array) {
        super(1L);
        this.array = array;
    }

    public void setByte(long offset, byte b) {
        throw new UnsupportedOperationException();
    }

    public void setMemory(long offset, long bytes, byte b) {
        throw new UnsupportedOperationException();
    }

    public void setLong(long offset, long l) {
        throw new UnsupportedOperationException();
    }

    public void setInt(long offset, int l) {
        throw new UnsupportedOperationException();
    }

    public void setShort(long offset, short l) {
        throw new UnsupportedOperationException();
    }

    public void setBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        throw new UnsupportedOperationException();
    }

    public void setBytes(long memoryOffset, ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public byte getByte(long offset) {
        throw new UnsupportedOperationException();
    }

    public long getLong(long offset) {
        this.checkBounds(offset, offset + 8L);
        int chunk = Ints.checkedCast((long)(offset / 8L));
        return this.array.get(chunk);
    }

    public int getInt(long offset) {
        throw new UnsupportedOperationException();
    }

    public void getBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        throw new UnsupportedOperationException();
    }

    protected void checkBounds(long start, long end) {
        int startChunk = Ints.checkedCast((long)(start / 8L));
        int endChunk = Ints.checkedCast((long)(end / 8L));
        assert (startChunk >= 0 && endChunk <= this.array.size && startChunk <= endChunk) : "Illegal bounds [" + start + ".." + end + "); size: " + this.array.size;
    }

    public void put(long trgOffset, Memory memory, long srcOffset, long size) {
        throw new UnsupportedOperationException();
    }

    public Memory copy(long newSize) {
        throw new UnsupportedOperationException();
    }

    public long size() {
        return (long)this.array.size * 8L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlignedReadonlyLongArrayMemory)) {
            return false;
        }
        AlignedReadonlyLongArrayMemory b = (AlignedReadonlyLongArrayMemory)((Object)o);
        return Objects.equals(this.array, b.array);
    }

    public int hashCode() {
        return Objects.hashCode(this.array);
    }

    public ByteBuffer asByteBuffer(long offset, int length) {
        throw new UnsupportedOperationException();
    }

    public void setByteBuffer(ByteBuffer buffer, long offset, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer[] asByteBuffers(long offset, long length) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("ReadonlyLongArrayMemory(%s)", this.array.size);
    }
}

