/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.validation;

import java.util.concurrent.TimeUnit;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.common.response.HealthResponse;
import org.apache.cassandra.spark.validation.StartupValidation;

public class CassandraValidation
implements StartupValidation {
    private final SidecarClient sidecar;
    private final int timeoutSeconds;

    public CassandraValidation(SidecarClient sidecar, int timeoutSeconds) {
        this.sidecar = sidecar;
        this.timeoutSeconds = timeoutSeconds;
    }

    public void validate() {
        HealthResponse health;
        try {
            health = (HealthResponse)this.sidecar.cassandraHealth().get(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Sidecar is unreachable", throwable);
        }
        if (!health.isOk()) {
            throw new RuntimeException("Cassandra is not healthy: " + health.status());
        }
    }
}

