/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.spark.sql.connector.read.partitioning.ClusteredDistribution;
import org.apache.spark.sql.connector.read.partitioning.Distribution;
import org.apache.spark.sql.connector.read.partitioning.Partitioning;

class CassandraPartitioning
implements Partitioning {
    final DataLayer dataLayer;

    CassandraPartitioning(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    public int numPartitions() {
        return this.dataLayer.partitionCount();
    }

    public boolean satisfy(Distribution distribution) {
        if (distribution instanceof ClusteredDistribution) {
            String[] clusteredCols = ((ClusteredDistribution)distribution).clusteredColumns;
            List partitionKeys = this.dataLayer.cqlTable().partitionKeys().stream().map(CqlField::name).collect(Collectors.toList());
            return Arrays.asList(clusteredCols).containsAll(partitionKeys);
        }
        return false;
    }
}

