/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleManifest;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleNameGenerator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableCollector;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTablesBundler;
import org.apache.cassandra.spark.common.DataObjectBuilder;
import org.apache.cassandra.spark.common.Digest;
import org.apache.commons.io.FileUtils;

public class Bundle {
    private static final String MANIFEST_FILE_NAME = "manifest.json";
    public final BigInteger firstToken;
    public final BigInteger endToken;
    public final long bundleUncompressedSize;
    public final long bundleCompressedSize;
    public final Path bundleDirectory;
    public final Path bundleFile;
    public final int bundleSequence;
    private final BundleManifest bundleManifest;
    private final List<SSTableCollector.SSTableFilesAndRange> sourceSSTables;

    static Builder builder() {
        return new Builder();
    }

    protected Bundle(Builder builder) {
        this.firstToken = builder.firstToken;
        this.endToken = builder.endToken;
        this.bundleManifest = builder.bundleManifest;
        this.bundleUncompressedSize = builder.bundleUncompressedSize;
        this.bundleCompressedSize = builder.bundleCompressedSize;
        this.bundleDirectory = builder.bundleDirectory;
        this.bundleFile = builder.bundleFile;
        this.bundleSequence = builder.bundleSequence;
        this.sourceSSTables = builder.sourceSSTables;
    }

    public void deleteAll() throws IOException {
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
        this.sourceSSTables.forEach(sstable -> sstable.files.forEach(path -> {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                ioExceptions.add(e);
            }
        }));
        try {
            FileUtils.deleteDirectory((File)this.bundleDirectory.toFile());
        }
        catch (IOException e) {
            ioExceptions.add(e);
        }
        try {
            Files.deleteIfExists(this.bundleFile);
        }
        catch (IOException e) {
            ioExceptions.add(e);
        }
        if (!ioExceptions.isEmpty()) {
            IOException ioe = new IOException("Failed to delete all files of a bundle");
            ioExceptions.forEach(ioe::addSuppressed);
            throw ioe;
        }
    }

    @VisibleForTesting
    BundleManifest.Entry manifestEntry(String key) {
        return (BundleManifest.Entry)this.bundleManifest.get(key);
    }

    public String toString() {
        return "BundleManifest{entryCount: " + this.bundleManifest.size() + ", bundleSequence: " + this.bundleSequence + ", bundleFile: " + String.valueOf(this.bundleFile) + ", uncompressedSize: " + this.bundleUncompressedSize + ", compressedSize: " + this.bundleCompressedSize + ", firstToken: " + String.valueOf(this.firstToken) + ", endToken: " + String.valueOf(this.endToken) + "}";
    }

    static class Builder
    implements DataObjectBuilder<Builder, Bundle> {
        private final BundleManifest bundleManifest = new BundleManifest();
        private BigInteger firstToken;
        private BigInteger endToken;
        private Path bundleStagingDirectory;
        private Path bundleDirectory;
        private Path bundleFile;
        private int bundleSequence;
        private List<SSTableCollector.SSTableFilesAndRange> sourceSSTables;
        private long bundleUncompressedSize;
        private long bundleCompressedSize;
        private BundleNameGenerator bundleNameGenerator;
        private Map<Path, Digest> fileDigests;

        Builder() {
        }

        public Builder bundleStagingDirectory(Path bundleStagingDirectory) {
            Preconditions.checkNotNull((Object)bundleStagingDirectory, (Object)"Cannot set bundle staging directory to null");
            return this.with(b -> {
                b.bundleStagingDirectory = bundleStagingDirectory;
            });
        }

        public Builder bundleNameGenerator(BundleNameGenerator bundleNameGenerator) {
            return this.with(b -> {
                b.bundleNameGenerator = bundleNameGenerator;
            });
        }

        public Builder fileDigests(Map<Path, Digest> fileDigests) {
            return this.with(b -> {
                b.fileDigests = fileDigests;
            });
        }

        public Builder bundleSequence(int bundleSequence) {
            Preconditions.checkArgument((bundleSequence >= 0 ? 1 : 0) != 0, (Object)"bundleSequence cannot be negative");
            return this.with(b -> {
                b.bundleSequence = bundleSequence;
            });
        }

        public Builder sourceSSTables(List<SSTableCollector.SSTableFilesAndRange> sourceSSTables) {
            Preconditions.checkArgument((sourceSSTables != null && !sourceSSTables.isEmpty() ? 1 : 0) != 0, (Object)"No files to bundle");
            return this.with(b -> {
                b.sourceSSTables = sourceSSTables;
                b.bundleUncompressedSize = sourceSSTables.stream().mapToLong(sstable -> sstable.size).sum();
            });
        }

        @Override
        public Bundle build() {
            try {
                this.prepareBuild();
            }
            catch (Exception ioe) {
                throw new RuntimeException("Unable to produce bundle manifest", ioe);
            }
            return new Bundle(this);
        }

        @Override
        public Builder self() {
            return this;
        }

        private void prepareBuild() throws IOException {
            this.bundleDirectory = this.bundleStagingDirectory.resolve(Integer.toString(this.bundleSequence));
            Files.createDirectories(this.bundleDirectory, new FileAttribute[0]);
            this.populateBundleManifestAndPersist();
            String bundleName = this.bundleNameGenerator.generate(this.firstToken, this.endToken);
            this.bundleFile = this.bundleStagingDirectory.resolve(bundleName);
            this.bundleCompressedSize = SSTablesBundler.zip(this.bundleDirectory, this.bundleFile);
        }

        private void populateBundleManifestAndPersist() throws IOException {
            int totalFiles = 0;
            for (SSTableCollector.SSTableFilesAndRange sstable : this.sourceSSTables) {
                totalFiles += sstable.files.size();
                BundleManifest.Entry manifestEntry = new BundleManifest.Entry(sstable.summary);
                for (Path componentPath : sstable.files) {
                    Digest digest = Objects.requireNonNull(this.fileDigests.get(componentPath), () -> "No digest found for file: " + String.valueOf(componentPath));
                    Path targetPath = this.bundleDirectory.resolve(componentPath.getFileName());
                    Files.createLink(targetPath, componentPath);
                    manifestEntry.addComponentChecksum(componentPath.getFileName().toString(), digest.value());
                }
                this.addManifestEntry(manifestEntry);
            }
            Preconditions.checkState((totalFiles == this.fileDigests.size() ? 1 : 0) != 0, (String)"SSTable files: %s does not match with the size of fileDigests: %s", (Object[])new Object[]{totalFiles, this.fileDigests.size()});
            this.bundleManifest.persistTo(this.bundleDirectory.resolve(Bundle.MANIFEST_FILE_NAME));
        }

        private void addManifestEntry(BundleManifest.Entry entry) {
            if (this.bundleManifest.isEmpty()) {
                this.firstToken = entry.firstToken();
                this.endToken = entry.endToken();
            } else {
                this.firstToken = this.firstToken.min(entry.firstToken());
                this.endToken = this.endToken.max(entry.endToken());
            }
            this.bundleManifest.addEntry(entry);
        }
    }
}

