/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.cassandra.spark.bulkwriter.BroadcastableTableSchema;
import org.apache.cassandra.spark.bulkwriter.DecoratedKey;
import org.apache.cassandra.spark.bulkwriter.token.TokenUtils;
import org.apache.cassandra.spark.common.schema.ColumnType;

public class Tokenizer
implements Serializable {
    private final TokenUtils tokenUtils;
    private final SerializableFunction<Object[], Object[]> keyColumnProvider;

    public Tokenizer(BroadcastableTableSchema broadcastableTableSchema, boolean isMurmur3Partitioner) {
        this.tokenUtils = new TokenUtils(broadcastableTableSchema.getPartitionKeyColumns(), broadcastableTableSchema.getPartitionKeyColumnTypes(), isMurmur3Partitioner);
        this.keyColumnProvider = broadcastableTableSchema::getKeyColumns;
    }

    @VisibleForTesting
    public Tokenizer(List<Integer> keyColumnIndexes, List<String> partitionKeyColumns, List<ColumnType<?>> partitionKeyColumnTypes, boolean isMurmur3Partitioner) {
        this.keyColumnProvider = columns -> BroadcastableTableSchema.getKeyColumns(columns, keyColumnIndexes);
        this.tokenUtils = new TokenUtils(partitionKeyColumns, partitionKeyColumnTypes, isMurmur3Partitioner);
    }

    public DecoratedKey getDecoratedKey(Object[] columns) {
        Object[] keyColumns = (Object[])this.keyColumnProvider.apply(columns);
        ByteBuffer key = this.tokenUtils.getCompositeKey(keyColumns);
        return new DecoratedKey(this.tokenUtils.getToken(key), key);
    }

    static interface SerializableFunction<T, R>
    extends Function<T, R>,
    Serializable {
    }
}

