/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.jfr.parser;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.internal.model.FLRStackTrace;
import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.internal.model.FLRType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.codec.stacktrace.ThreadTraceEvent;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.GenericEvent;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.event.SimpleErrorEvent;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;

public class JfrEventAdapter
implements EventReader<Event> {
    private static final String METHOD_PROFILING_SAMPLE = "Method Profiling Sample";
    private static final String ALLOCATION_IN_NEW_TLAB = "Allocation in new TLAB";
    private final Iterator<IEvent> it;
    private ThreadSnapshotEventPojo threadPojo = new ThreadSnapshotEventPojo();
    private NewTLABEventPojo allocPojo = new NewTLABEventPojo();
    private Event event = null;
    private boolean error;

    public JfrEventAdapter(FlightRecording recording) {
        this.it = recording.createView().iterator();
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }

    private void seek() {
        if (this.error) {
            return;
        }
        try {
            while (this.it.hasNext()) {
                IEvent e = this.it.next();
                String type = e.getEventType().getName();
                if (METHOD_PROFILING_SAMPLE.equals(type)) {
                    this.event = this.parseThreadSample(e);
                    return;
                }
                if (!ALLOCATION_IN_NEW_TLAB.equals(type)) continue;
                this.event = this.parseAllocation(e);
                return;
            }
        }
        catch (Exception e) {
            this.event = new SimpleErrorEvent(e);
            this.error = true;
        }
    }

    private Event parseThreadSample(IEvent e) {
        this.threadPojo.timestamp(TimeUnit.NANOSECONDS.toMillis(e.getStartTimestamp()));
        FLRThread thread = (FLRThread)e.getValue("(thread)");
        if (thread != null) {
            this.threadPojo.threadId(thread.getThreadId());
            this.threadPojo.threadName(thread.getThreadName());
        } else {
            this.threadPojo.threadId(-1L);
            this.threadPojo.threadName(null);
        }
        FLRStackTrace flrStackTrace = (FLRStackTrace)e.getValue("(stackTrace)");
        if (flrStackTrace != null) {
            this.threadPojo.stackTrace(this.trace(flrStackTrace));
        } else {
            this.threadPojo.stackTrace(null);
        }
        return this.threadPojo;
    }

    private Event parseAllocation(IEvent e) {
        Long tlabSize;
        Long allocaSize;
        FLRStackTrace flrStackTrace;
        this.allocPojo.counters().clear();
        this.allocPojo.tags().clear();
        this.allocPojo.tags().put("jfr.event", "");
        this.allocPojo.tags().put("jfr.event.name", e.getEventType().getName());
        this.allocPojo.timestamp(TimeUnit.NANOSECONDS.toMillis(e.getStartTimestamp()));
        FLRThread thread = (FLRThread)e.getValue("(thread)");
        if (thread != null) {
            this.allocPojo.counters().set("jfr.threadId", thread.getThreadId());
            this.allocPojo.tags().put("jfr.threadName", thread.getThreadName());
        }
        if ((flrStackTrace = (FLRStackTrace)e.getValue("(stackTrace)")) != null) {
            this.allocPojo.stackTrace(this.trace(flrStackTrace));
        } else {
            this.allocPojo.stackTrace(null);
        }
        FLRType type = (FLRType)e.getValue("class");
        if (type != null) {
            this.allocPojo.tags().put("jfr.allocClass", this.name(type));
        }
        if ((allocaSize = (Long)e.getValue("allocationSize")) != null) {
            this.allocPojo.counters().set("jfr.allocationSize", allocaSize);
        }
        if ((tlabSize = (Long)e.getValue("tlabSize")) != null) {
            this.allocPojo.counters().set("jfr.tlabSize", tlabSize);
        }
        return this.allocPojo;
    }

    private String name(FLRType type) {
        String name = (type.getPackageName().length() == 0 ? "" : type.getPackageName()) + "." + type.getTypeName() + (type.getIsArray() != false ? "[]" : "");
        return name;
    }

    private StackFrameList trace(FLRStackTrace trace) {
        StackFrame[] t = new StackFrame[trace.getFrames().size()];
        for (int i = 0; i != t.length; ++i) {
            t[i] = this.frame((IMCFrame)trace.getFrames().get(i));
        }
        return new StackFrameArray(t);
    }

    private StackFrame frame(IMCFrame f) {
        String src;
        int line;
        String pn = f.getMethod().getPackageName();
        String cn = f.getMethod().getClassName();
        String mn = f.getMethod().getMethodName();
        int n = line = f.getFrameLineNumber() == null ? -1 : f.getFrameLineNumber();
        if (f.getMethod().getIsNative().booleanValue()) {
            line = -2;
        }
        if ((src = f.getMethod().getFileName()) == null && line >= 0) {
            src = "line";
        }
        return new StackFrame(pn, cn, mn, src, line);
    }

    @Override
    public boolean hasNext() {
        if (this.event == null) {
            this.seek();
        }
        return this.event != null;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Event e = this.event;
        this.event = null;
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<Event, M> morpher) {
        return new MorphingEventReader<M>(this, morpher);
    }

    @Override
    public Event peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.event;
    }

    @Override
    public void dispose() {
    }

    private static class NewTLABEventPojo
    extends GenericEvent
    implements ThreadTraceEvent {
        private StackFrameList trace;

        private NewTLABEventPojo() {
        }

        @Override
        public StackFrameList stackTrace() {
            return this.trace;
        }

        public void stackTrace(StackFrameList trace) {
            this.trace = trace;
        }
    }
}

