/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.cassandra.db.Digest;

public final class SchemaConstants {
    public static final Pattern PATTERN_WORD_CHARS = Pattern.compile("\\w+");
    public static final String SYSTEM_KEYSPACE_NAME = "system";
    public static final String SCHEMA_KEYSPACE_NAME = "system_schema";
    public static final String TRACE_KEYSPACE_NAME = "system_traces";
    public static final String AUTH_KEYSPACE_NAME = "system_auth";
    public static final String DISTRIBUTED_KEYSPACE_NAME = "system_distributed";
    public static final String VIRTUAL_SCHEMA = "system_virtual_schema";
    public static final String VIRTUAL_VIEWS = "system_views";
    public static final Set<String> LOCAL_SYSTEM_KEYSPACE_NAMES = ImmutableSet.of("system", "system_schema");
    public static final Set<String> REPLICATED_SYSTEM_KEYSPACE_NAMES = ImmutableSet.of("system_traces", "system_auth", "system_distributed");
    public static final int NAME_LENGTH = 48;
    public static final UUID emptyVersion;
    public static final List<String> LEGACY_AUTH_TABLES;

    public static boolean isValidName(String name) {
        return name != null && !name.isEmpty() && name.length() <= 48 && PATTERN_WORD_CHARS.matcher(name).matches();
    }

    public static boolean isLocalSystemKeyspace(String keyspaceName) {
        return LOCAL_SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase());
    }

    public static boolean isReplicatedSystemKeyspace(String keyspaceName) {
        return REPLICATED_SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase());
    }

    public static boolean isVirtualSystemKeyspace(String keyspaceName) {
        return VIRTUAL_SCHEMA.equals(keyspaceName.toLowerCase()) || VIRTUAL_VIEWS.equals(keyspaceName.toLowerCase());
    }

    public static boolean isSystemKeyspace(String keyspaceName) {
        return SchemaConstants.isLocalSystemKeyspace(keyspaceName) || SchemaConstants.isReplicatedSystemKeyspace(keyspaceName) || SchemaConstants.isVirtualSystemKeyspace(keyspaceName);
    }

    public static boolean isNonVirtualSystemKeyspace(String keyspaceName) {
        String lowercaseKeyspaceName = keyspaceName.toLowerCase();
        return LOCAL_SYSTEM_KEYSPACE_NAMES.contains(lowercaseKeyspaceName) || REPLICATED_SYSTEM_KEYSPACE_NAMES.contains(lowercaseKeyspaceName);
    }

    static {
        LEGACY_AUTH_TABLES = Arrays.asList("credentials", "users", "permissions");
        emptyVersion = UUID.nameUUIDFromBytes(Digest.forSchema().digest());
    }
}

