/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.TableMetadata;

public final class CompactionInfo {
    public static final String ID = "id";
    public static final String KEYSPACE = "keyspace";
    public static final String COLUMNFAMILY = "columnfamily";
    public static final String COMPLETED = "completed";
    public static final String TOTAL = "total";
    public static final String TASK_TYPE = "taskType";
    public static final String UNIT = "unit";
    public static final String COMPACTION_ID = "compactionId";
    public static final String SSTABLES = "sstables";
    private final TableMetadata metadata;
    private final OperationType tasktype;
    private final long completed;
    private final long total;
    private final Unit unit;
    private final UUID compactionId;
    private final ImmutableSet<SSTableReader> sstables;

    public CompactionInfo(TableMetadata metadata, OperationType tasktype, long bytesComplete, long totalBytes, UUID compactionId, Collection<SSTableReader> sstables) {
        this(metadata, tasktype, bytesComplete, totalBytes, Unit.BYTES, compactionId, sstables);
    }

    private CompactionInfo(TableMetadata metadata, OperationType tasktype, long completed, long total, Unit unit, UUID compactionId, Collection<SSTableReader> sstables) {
        this.tasktype = tasktype;
        this.completed = completed;
        this.total = total;
        this.metadata = metadata;
        this.unit = unit;
        this.compactionId = compactionId;
        this.sstables = ImmutableSet.copyOf(sstables);
    }

    public static CompactionInfo withoutSSTables(TableMetadata metadata, OperationType tasktype, long completed, long total, Unit unit, UUID compactionId) {
        return new CompactionInfo(metadata, tasktype, completed, total, unit, compactionId, ImmutableSet.of());
    }

    public CompactionInfo forProgress(long complete, long total) {
        return new CompactionInfo(this.metadata, this.tasktype, complete, total, this.unit, this.compactionId, this.sstables);
    }

    public Optional<String> getKeyspace() {
        return Optional.ofNullable(this.metadata != null ? this.metadata.keyspace : null);
    }

    public Optional<String> getTable() {
        return Optional.ofNullable(this.metadata != null ? this.metadata.name : null);
    }

    public TableMetadata getTableMetadata() {
        return this.metadata;
    }

    public long getCompleted() {
        return this.completed;
    }

    public long getTotal() {
        return this.total;
    }

    public OperationType getTaskType() {
        return this.tasktype;
    }

    public UUID getTaskId() {
        return this.compactionId;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Set<SSTableReader> getSSTables() {
        return this.sstables;
    }

    public String toString() {
        if (this.metadata != null) {
            return String.format("%s(%s, %s / %s %s)@%s(%s, %s)", new Object[]{this.tasktype, this.compactionId, this.completed, this.total, this.unit, this.metadata.id, this.metadata.keyspace, this.metadata.name});
        }
        return String.format("%s(%s, %s / %s %s)", new Object[]{this.tasktype, this.compactionId, this.completed, this.total, this.unit});
    }

    public Map<String, String> asMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(ID, this.metadata != null ? this.metadata.id.toString() : "");
        ret.put(KEYSPACE, this.getKeyspace().orElse(null));
        ret.put(COLUMNFAMILY, this.getTable().orElse(null));
        ret.put(COMPLETED, Long.toString(this.completed));
        ret.put(TOTAL, Long.toString(this.total));
        ret.put(TASK_TYPE, this.tasktype.toString());
        ret.put(UNIT, this.unit.toString());
        ret.put(COMPACTION_ID, this.compactionId == null ? "" : this.compactionId.toString());
        ret.put(SSTABLES, Joiner.on(',').join(this.sstables));
        return ret;
    }

    boolean shouldStop(Predicate<SSTableReader> sstablePredicate) {
        if (this.sstables.isEmpty()) {
            return true;
        }
        return this.sstables.stream().anyMatch(sstablePredicate);
    }

    public static enum Unit {
        BYTES("bytes"),
        RANGES("token range parts"),
        KEYS("keys");

        private final String name;

        private Unit(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean isFileSize(String unit) {
            return BYTES.toString().equals(unit);
        }
    }

    public static abstract class Holder {
        private volatile boolean stopRequested = false;

        public abstract CompactionInfo getCompactionInfo();

        public void stop() {
            this.stopRequested = true;
        }

        public abstract boolean isGlobal();

        public boolean isStopRequested() {
            return this.stopRequested || this.isGlobal() && CompactionManager.instance.isGlobalCompactionPaused();
        }
    }
}

