/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.UnboundedLocalCache;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.stats.ConcurrentStatsCounter;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class Caffeine<K, V> {
    static final Logger logger = Logger.getLogger(Caffeine.class.getName());
    static final Supplier<StatsCounter> ENABLED_STATS_COUNTER_SUPPLIER = ConcurrentStatsCounter::new;
    static final int UNSET_INT = -1;
    static final int DEFAULT_INITIAL_CAPACITY = 0;
    static final int DEFAULT_EXPIRATION_NANOS = 0;
    static final int DEFAULT_REFRESH_NANOS = 0;
    boolean strictParsing = true;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    int initialCapacity = -1;
    long refreshNanos = -1L;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    RemovalListener<? super K, ? super V> removalListener;
    Supplier<StatsCounter> statsCounterSupplier;
    CacheWriter<? super K, ? super V> writer;
    Weigher<? super K, ? super V> weigher;
    Expiry<? super K, ? super V> expiry;
    Executor executor;
    Ticker ticker;
    Strength keyStrength;
    Strength valueStrength;

    private Caffeine() {
    }

    static void requireArgument(boolean expression, String template, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(template, args));
        }
    }

    static void requireArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    static void requireState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    static void requireState(boolean expression, String template, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(template, args));
        }
    }

    @Nonnull
    public static Caffeine<Object, Object> newBuilder() {
        return new Caffeine<Object, Object>();
    }

    @Nonnull
    public static Caffeine<Object, Object> from(CaffeineSpec spec) {
        Caffeine<Object, Object> builder = spec.toBuilder();
        builder.strictParsing = false;
        return builder;
    }

    @Nonnull
    public static Caffeine<Object, Object> from(String spec) {
        return Caffeine.from(CaffeineSpec.parse(spec));
    }

    @Nonnull
    public Caffeine<K, V> initialCapacity(@Nonnegative int initialCapacity) {
        Caffeine.requireState(this.initialCapacity == -1, "initial capacity was already set to %s", this.initialCapacity);
        Caffeine.requireArgument(initialCapacity >= 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    boolean hasInitialCapacity() {
        return this.initialCapacity != -1;
    }

    int getInitialCapacity() {
        return this.hasInitialCapacity() ? this.initialCapacity : 0;
    }

    @Nonnull
    public Caffeine<K, V> executor(@Nonnull Executor executor) {
        Caffeine.requireState(this.executor == null, "executor was already set to %s", this.executor);
        this.executor = Objects.requireNonNull(executor);
        return this;
    }

    @Nonnull
    Executor getExecutor() {
        return this.executor == null ? ForkJoinPool.commonPool() : this.executor;
    }

    @Nonnull
    public Caffeine<K, V> maximumSize(@Nonnegative long maximumSize) {
        Caffeine.requireState(this.maximumSize == -1L, "maximum size was already set to %s", this.maximumSize);
        Caffeine.requireState(this.maximumWeight == -1L, "maximum weight was already set to %s", this.maximumWeight);
        Caffeine.requireState(this.weigher == null, "maximum size can not be combined with weigher", new Object[0]);
        Caffeine.requireArgument(maximumSize >= 0L, "maximum size must not be negative", new Object[0]);
        this.maximumSize = maximumSize;
        return this;
    }

    @Nonnull
    public Caffeine<K, V> maximumWeight(@Nonnegative long maximumWeight) {
        Caffeine.requireState(this.maximumWeight == -1L, "maximum weight was already set to %s", this.maximumWeight);
        Caffeine.requireState(this.maximumSize == -1L, "maximum size was already set to %s", this.maximumSize);
        this.maximumWeight = maximumWeight;
        Caffeine.requireArgument(maximumWeight >= 0L, "maximum weight must not be negative", new Object[0]);
        return this;
    }

    @Nonnull
    public <K1 extends K, V1 extends V> Caffeine<K1, V1> weigher(@Nonnull Weigher<? super K1, ? super V1> weigher) {
        Objects.requireNonNull(weigher);
        Caffeine.requireState(this.weigher == null, "weigher was already set to %s", this.weigher);
        Caffeine.requireState(!this.strictParsing || this.maximumSize == -1L, "weigher can not be combined with maximum size", this.maximumSize);
        Caffeine self = this;
        self.weigher = weigher;
        return self;
    }

    boolean evicts() {
        return this.getMaximum() != -1L;
    }

    boolean isWeighted() {
        return this.weigher != null;
    }

    @Nonnegative
    long getMaximum() {
        return this.isWeighted() ? this.maximumWeight : this.maximumSize;
    }

    @Nonnull
    <K1 extends K, V1 extends V> Weigher<K1, V1> getWeigher(boolean isAsync) {
        Async.AsyncWeigher delegate = this.isWeighted() && this.weigher != Weigher.singletonWeigher() ? Weigher.boundedWeigher(this.weigher) : Weigher.singletonWeigher();
        return isAsync ? new Async.AsyncWeigher(delegate) : delegate;
    }

    @Nonnull
    public Caffeine<K, V> weakKeys() {
        Caffeine.requireState(this.keyStrength == null, "Key strength was already set to %s", new Object[]{this.keyStrength});
        Caffeine.requireState(this.writer == null, "Weak keys may not be used with CacheWriter", new Object[0]);
        this.keyStrength = Strength.WEAK;
        return this;
    }

    boolean isStrongKeys() {
        return this.keyStrength == null;
    }

    @Nonnull
    public Caffeine<K, V> weakValues() {
        Caffeine.requireState(this.valueStrength == null, "Value strength was already set to %s", new Object[]{this.valueStrength});
        this.valueStrength = Strength.WEAK;
        return this;
    }

    boolean isStrongValues() {
        return this.valueStrength == null;
    }

    boolean isWeakValues() {
        return this.valueStrength == Strength.WEAK;
    }

    @Nonnull
    public Caffeine<K, V> softValues() {
        Caffeine.requireState(this.valueStrength == null, "Value strength was already set to %s", new Object[]{this.valueStrength});
        this.valueStrength = Strength.SOFT;
        return this;
    }

    @Nonnull
    public Caffeine<K, V> expireAfterWrite(@Nonnegative long duration, @Nonnull TimeUnit unit) {
        Caffeine.requireState(this.expireAfterWriteNanos == -1L, "expireAfterWrite was already set to %s ns", this.expireAfterWriteNanos);
        Caffeine.requireState(this.expiry == null, "expireAfterAccess may not be used with variable expiration", new Object[0]);
        Caffeine.requireArgument(duration >= 0L, "duration cannot be negative: %s %s", new Object[]{duration, unit});
        this.expireAfterWriteNanos = unit.toNanos(duration);
        return this;
    }

    @Nonnegative
    long getExpiresAfterWriteNanos() {
        return this.expiresAfterWrite() ? this.expireAfterWriteNanos : 0L;
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos != -1L;
    }

    @Nonnull
    public Caffeine<K, V> expireAfterAccess(@Nonnegative long duration, @Nonnull TimeUnit unit) {
        Caffeine.requireState(this.expireAfterAccessNanos == -1L, "expireAfterAccess was already set to %s ns", this.expireAfterAccessNanos);
        Caffeine.requireState(this.expiry == null, "expireAfterAccess may not be used with variable expiration", new Object[0]);
        Caffeine.requireArgument(duration >= 0L, "duration cannot be negative: %s %s", new Object[]{duration, unit});
        this.expireAfterAccessNanos = unit.toNanos(duration);
        return this;
    }

    @Nonnegative
    long getExpiresAfterAccessNanos() {
        return this.expiresAfterAccess() ? this.expireAfterAccessNanos : 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos != -1L;
    }

    @Nonnull
    public <K1 extends K, V1 extends V> Caffeine<K1, V1> expireAfter(@Nonnull Expiry<? super K1, ? super V1> expiry) {
        Objects.requireNonNull(expiry);
        Caffeine.requireState(this.expiry == null, "Expiry was already set to %s", this.expiry);
        Caffeine.requireState(this.expireAfterAccessNanos == -1L, "Expiry may not be used with expiresAfterAccess", new Object[0]);
        Caffeine.requireState(this.expireAfterWriteNanos == -1L, "Expiry may not be used with expiresAfterWrite", new Object[0]);
        Caffeine self = this;
        self.expiry = expiry;
        return self;
    }

    boolean expiresVariable() {
        return this.expiry != null;
    }

    Expiry<K, V> getExpiry(boolean isAsync) {
        return isAsync && this.expiry != null ? new Async.AsyncExpiry<K, V>(this.expiry) : this.expiry;
    }

    @Nonnull
    public Caffeine<K, V> refreshAfterWrite(@Nonnegative long duration, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(unit);
        Caffeine.requireState(this.refreshNanos == -1L, "refresh was already set to %s ns", this.refreshNanos);
        Caffeine.requireArgument(duration > 0L, "duration must be positive: %s %s", new Object[]{duration, unit});
        this.refreshNanos = unit.toNanos(duration);
        return this;
    }

    @Nonnegative
    long getRefreshAfterWriteNanos() {
        return this.refreshes() ? this.refreshNanos : 0L;
    }

    boolean refreshes() {
        return this.refreshNanos != -1L;
    }

    @Nonnull
    public Caffeine<K, V> ticker(@Nonnull Ticker ticker) {
        Caffeine.requireState(this.ticker == null, "Ticker was already set to %s", this.ticker);
        this.ticker = Objects.requireNonNull(ticker);
        return this;
    }

    @Nonnull
    Ticker getTicker() {
        boolean useTicker;
        boolean bl = useTicker = this.expiresVariable() || this.expiresAfterAccess() || this.expiresAfterWrite() || this.refreshes() || this.isRecordingStats();
        return useTicker ? (this.ticker == null ? Ticker.systemTicker() : this.ticker) : Ticker.disabledTicker();
    }

    @Nonnull
    public <K1 extends K, V1 extends V> Caffeine<K1, V1> removalListener(@Nonnull RemovalListener<? super K1, ? super V1> removalListener) {
        Caffeine.requireState(this.removalListener == null);
        Caffeine self = this;
        self.removalListener = Objects.requireNonNull(removalListener);
        return self;
    }

    <K1 extends K, V1 extends V> RemovalListener<K1, V1> getRemovalListener(boolean async) {
        Async.AsyncRemovalListener castedListener = this.removalListener;
        return async && castedListener != null ? new Async.AsyncRemovalListener(castedListener, this.getExecutor()) : castedListener;
    }

    @Nonnull
    public <K1 extends K, V1 extends V> Caffeine<K1, V1> writer(@Nonnull CacheWriter<? super K1, ? super V1> writer) {
        Caffeine.requireState(this.writer == null, "Writer was already set to %s", this.writer);
        Caffeine.requireState(this.keyStrength == null, "Weak keys may not be used with CacheWriter", new Object[0]);
        Caffeine self = this;
        self.writer = Objects.requireNonNull(writer);
        return self;
    }

    <K1 extends K, V1 extends V> CacheWriter<K1, V1> getCacheWriter() {
        CacheWriter<? super K, ? super V> castedWriter = this.writer;
        return this.writer == null ? CacheWriter.disabledWriter() : castedWriter;
    }

    @Nonnull
    public Caffeine<K, V> recordStats() {
        Caffeine.requireState(this.statsCounterSupplier == null, "Statistics recording was already set", new Object[0]);
        this.statsCounterSupplier = ENABLED_STATS_COUNTER_SUPPLIER;
        return this;
    }

    @Nonnull
    public Caffeine<K, V> recordStats(@Nonnull Supplier<? extends StatsCounter> statsCounterSupplier) {
        Caffeine.requireState(this.statsCounterSupplier == null, "Statistics recording was already set", new Object[0]);
        Objects.requireNonNull(statsCounterSupplier);
        this.statsCounterSupplier = () -> StatsCounter.guardedStatsCounter((StatsCounter)statsCounterSupplier.get());
        return this;
    }

    boolean isRecordingStats() {
        return this.statsCounterSupplier != null;
    }

    @Nonnull
    Supplier<StatsCounter> getStatsCounterSupplier() {
        return this.statsCounterSupplier == null ? StatsCounter::disabledStatsCounter : this.statsCounterSupplier;
    }

    boolean isBounded() {
        return this.maximumSize != -1L || this.maximumWeight != -1L || this.expireAfterAccessNanos != -1L || this.expireAfterWriteNanos != -1L || this.expiry != null || this.keyStrength != null || this.valueStrength != null;
    }

    @Nonnull
    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        this.requireWeightWithWeigher();
        this.requireNonLoadingCache();
        Caffeine self = this;
        return this.isBounded() || this.refreshes() ? new BoundedLocalCache.BoundedLocalManualCache(self) : new UnboundedLocalCache.UnboundedLocalManualCache(self);
    }

    @Nonnull
    public <K1 extends K, V1 extends V> LoadingCache<K1, V1> build(@Nonnull CacheLoader<? super K1, V1> loader) {
        this.requireWeightWithWeigher();
        Caffeine self = this;
        return this.isBounded() || this.refreshes() ? new BoundedLocalCache.BoundedLocalLoadingCache<K1, V1>(self, loader) : new UnboundedLocalCache.UnboundedLocalLoadingCache<K1, V1>(self, loader);
    }

    @Nonnull
    public <K1 extends K, V1 extends V> AsyncLoadingCache<K1, V1> buildAsync(@Nonnull CacheLoader<? super K1, V1> loader) {
        return this.buildAsync((AsyncCacheLoader<? super K1, V1>)loader);
    }

    @Nonnull
    public <K1 extends K, V1 extends V> AsyncLoadingCache<K1, V1> buildAsync(@Nonnull AsyncCacheLoader<? super K1, V1> loader) {
        Caffeine.requireState(this.valueStrength == null);
        Caffeine.requireState(this.writer == null);
        this.requireWeightWithWeigher();
        Objects.requireNonNull(loader);
        Caffeine self = this;
        return this.isBounded() || this.refreshes() ? new BoundedLocalCache.BoundedLocalAsyncLoadingCache<K1, V1>(self, loader) : new UnboundedLocalCache.UnboundedLocalAsyncLoadingCache<K1, V1>(self, loader);
    }

    void requireNonLoadingCache() {
        Caffeine.requireState(this.refreshNanos == -1L, "refreshAfterWrite requires a LoadingCache", new Object[0]);
    }

    void requireWeightWithWeigher() {
        if (this.weigher == null) {
            Caffeine.requireState(this.maximumWeight == -1L, "maximumWeight requires weigher", new Object[0]);
        } else if (this.strictParsing) {
            Caffeine.requireState(this.maximumWeight != -1L, "weigher requires maximumWeight", new Object[0]);
        } else if (this.maximumWeight == -1L) {
            logger.log(Level.WARNING, "ignoring weigher specified without maximumWeight");
        }
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder(64);
        s2.append(this.getClass().getSimpleName()).append('{');
        int baseLength = s2.length();
        if (this.initialCapacity != -1) {
            s2.append("initialCapacity=").append(this.initialCapacity).append(", ");
        }
        if (this.maximumSize != -1L) {
            s2.append("maximumSize=").append(this.maximumSize).append(", ");
        }
        if (this.maximumWeight != -1L) {
            s2.append("maximumWeight=").append(this.maximumWeight).append(", ");
        }
        if (this.expireAfterWriteNanos != -1L) {
            s2.append("expireAfterWrite=").append(this.expireAfterWriteNanos).append("ns, ");
        }
        if (this.expireAfterAccessNanos != -1L) {
            s2.append("expireAfterAccess=").append(this.expireAfterAccessNanos).append("ns, ");
        }
        if (this.expiry != null) {
            s2.append("expiry, ");
        }
        if (this.refreshNanos != -1L) {
            s2.append("refreshNanos=").append(this.refreshNanos).append("ns, ");
        }
        if (this.keyStrength != null) {
            s2.append("keyStrength=").append(this.keyStrength.toString().toLowerCase()).append(", ");
        }
        if (this.valueStrength != null) {
            s2.append("valueStrength=").append(this.valueStrength.toString().toLowerCase()).append(", ");
        }
        if (this.removalListener != null) {
            s2.append("removalListener, ");
        }
        if (this.writer != null) {
            s2.append("writer, ");
        }
        if (s2.length() > baseLength) {
            s2.deleteCharAt(s2.length() - 2);
        }
        return s2.append('}').toString();
    }

    static enum Strength {
        WEAK,
        SOFT;

    }
}

