/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipInputStream;
import org.apache.cassandra.spark.bulkwriter.util.IOUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class IOUtilsTest {
    @TempDir
    private Path tempFolder;

    IOUtilsTest() {
    }

    @Test
    void testZip() throws Exception {
        File zipSourceDir = Files.createDirectories(this.tempFolder.resolve("zipSource"), new FileAttribute[0]).toFile();
        int expectedFileCount = 10;
        for (int i = 0; i < expectedFileCount; ++i) {
            new File(zipSourceDir, Integer.toString(i)).createNewFile();
        }
        File targetZip = this.tempFolder.resolve("zip").toFile();
        long zipFileSize = IOUtils.zip((Path)zipSourceDir.toPath(), (Path)targetZip.toPath());
        Assertions.assertThat((File)targetZip).exists();
        Assertions.assertThat((long)zipFileSize).isGreaterThan(0L);
        ZipInputStream zis = new ZipInputStream(new FileInputStream(targetZip));
        int acutalFilesCount = 0;
        while (zis.getNextEntry() != null) {
            ++acutalFilesCount;
        }
        Assertions.assertThat((int)acutalFilesCount).isEqualTo(expectedFileCount);
    }

    @Test
    void testZipFailsOnInvalidInput() {
        Path file = this.tempFolder.resolve("file");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IOUtils.zip((Path)file, (Path)file)).isInstanceOf(IOException.class)).hasMessageContaining("Not a directory");
    }

    @Test
    void testChecksumCalculationShouldBeDeterministic() throws Exception {
        Path file = this.tempFolder.resolve("file");
        Files.write(file, "Hello World!".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String checksum1 = IOUtils.xxhash32((Path)file);
        String checksum2 = IOUtils.xxhash32((Path)file);
        ((AbstractStringAssert)Assertions.assertThat((String)checksum2).as("Deterministic checksum calculation should yield same result for same input", new Object[0])).isEqualTo(checksum1);
        Assertions.assertThat((String)checksum1).isEqualTo("bd69788");
        Path anotherFile = this.tempFolder.resolve("anotherFile");
        Files.write(anotherFile, "Hello World!".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String checksum3 = IOUtils.xxhash32((Path)anotherFile);
        ((AbstractStringAssert)Assertions.assertThat((String)checksum3).as("Checksum should be same for the same content", new Object[0])).isEqualTo(checksum1);
    }

    @Test
    void testChecksumShouldBeDifferentForDifferentContent() throws Exception {
        Path file1 = this.tempFolder.resolve("file1");
        Path file2 = this.tempFolder.resolve("file2");
        Files.write(file1, "I am in file 1".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(file2, "File 2 is where you find me".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String checksum1 = IOUtils.xxhash32((Path)file1);
        String checksum2 = IOUtils.xxhash32((Path)file2);
        Assertions.assertThat((String)checksum1).isNotEqualTo((Object)checksum2);
        Assertions.assertThat((String)checksum1).isEqualTo("a6a6a5ba");
        Assertions.assertThat((String)checksum2).isEqualTo("9e9b9db5");
    }
}

