/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.util.EnumSet;
import org.apache.cassandra.spark.bulkwriter.WriteAvailability;
import org.apache.cassandra.spark.common.model.NodeState;
import org.apache.cassandra.spark.common.model.NodeStatus;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WriteAvailabilityTest {
    WriteAvailabilityTest() {
    }

    @Test
    void testDetermineWriteAvailability() {
        EnumSet<WriteAvailability> results = EnumSet.noneOf(WriteAvailability.class);
        for (NodeState state : NodeState.values()) {
            for (NodeStatus status : NodeStatus.values()) {
                WriteAvailability res = WriteAvailability.determineFromNodeState((NodeState)state, (NodeStatus)status);
                results.add(res);
                if (status != NodeStatus.UP) {
                    Assertions.assertThat((Comparable)res).isEqualTo((Object)WriteAvailability.UNAVAILABLE_DOWN);
                    continue;
                }
                Assertions.assertThat((Comparable)res).isEqualTo((Object)WriteAvailability.AVAILABLE);
            }
        }
        ((AbstractCollectionAssert)Assertions.assertThat(results).containsExactlyInAnyOrder((Object[])new WriteAvailability[]{WriteAvailability.AVAILABLE, WriteAvailability.UNAVAILABLE_DOWN})).doesNotContain((Object[])new WriteAvailability[]{WriteAvailability.INVALID_STATE});
    }
}

