/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Interact with Ethereum nodes using web3j client API.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Web3jEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Web3j Ethereum Blockchain component.
     */
    public interface Web3jEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWeb3jEndpointConsumerBuilder advanced() {
            return (AdvancedWeb3jEndpointConsumerBuilder) this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder addresses(List<java.lang.String> addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * The address the transaction is send from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param fromAddress the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder fromAddress(String fromAddress) {
            doSetProperty("fromAddress", fromAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: common
         * 
         * @param fromBlock the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder fromBlock(String fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param fullTransactionObjects the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder fullTransactionObjects(boolean fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param fullTransactionObjects the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder fullTransactionObjects(String fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: common
         * 
         * @param gasLimit the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder gasLimit(java.math.BigInteger gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: common
         * 
         * @param gasLimit the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder gasLimit(String gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param privateFor the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder privateFor(List<java.lang.String> privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param privateFor the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder privateFor(String privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param quorumAPI the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder quorumAPI(boolean quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param quorumAPI the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder quorumAPI(String quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * The address the transaction is directed to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param toAddress the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder toAddress(String toAddress) {
            doSetProperty("toAddress", toAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: common
         * 
         * @param toBlock the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder toBlock(String toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param topics the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder topics(String topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option is a: <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         * 
         * @param web3j the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder web3j(org.web3j.protocol.Web3j web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         * 
         * @param web3j the value to set
         * @return the dsl builder
         */
        default Web3jEndpointConsumerBuilder web3j(String web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Web3j Ethereum Blockchain component.
     */
    public interface AdvancedWeb3jEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Web3jEndpointConsumerBuilder basic() {
            return (Web3jEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWeb3jEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWeb3jEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWeb3jEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWeb3jEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWeb3jEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWeb3jEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Web3j Ethereum Blockchain component.
     */
    public interface Web3jEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWeb3jEndpointProducerBuilder advanced() {
            return (AdvancedWeb3jEndpointProducerBuilder) this;
        }

        /**
         * Contract address or a list of addresses.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder addresses(List<java.lang.String> addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * The address the transaction is send from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param fromAddress the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder fromAddress(String fromAddress) {
            doSetProperty("fromAddress", fromAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: common
         * 
         * @param fromBlock the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder fromBlock(String fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param fullTransactionObjects the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder fullTransactionObjects(boolean fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param fullTransactionObjects the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder fullTransactionObjects(String fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: common
         * 
         * @param gasLimit the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder gasLimit(java.math.BigInteger gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: common
         * 
         * @param gasLimit the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder gasLimit(String gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param privateFor the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder privateFor(List<java.lang.String> privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param privateFor the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder privateFor(String privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param quorumAPI the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder quorumAPI(boolean quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param quorumAPI the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder quorumAPI(String quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * The address the transaction is directed to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param toAddress the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder toAddress(String toAddress) {
            doSetProperty("toAddress", toAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: common
         * 
         * @param toBlock the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder toBlock(String toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param topics the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder topics(String topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option is a: <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         * 
         * @param web3j the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder web3j(org.web3j.protocol.Web3j web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         * 
         * @param web3j the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder web3j(String web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * Contract address.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param address the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder address(String address) {
            doSetProperty("address", address);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: producer
         * 
         * @param atBlock the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder atBlock(String atBlock) {
            doSetProperty("atBlock", atBlock);
            return this;
        }
        /**
         * Hash of the block where this transaction was in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param blockHash the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder blockHash(String blockHash) {
            doSetProperty("blockHash", blockHash);
            return this;
        }
        /**
         * A random hexadecimal(32 bytes) ID identifying the client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The compiled code of a contract OR the hash of the invoked method
         * signature and encoded parameters.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param data the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder data(String data) {
            doSetProperty("data", data);
            return this;
        }
        /**
         * The local database name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param databaseName the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder databaseName(String databaseName) {
            doSetProperty("databaseName", databaseName);
            return this;
        }
        /**
         * The filter id to use.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         * 
         * @param filterId the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder filterId(java.math.BigInteger filterId) {
            doSetProperty("filterId", filterId);
            return this;
        }
        /**
         * The filter id to use.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         * 
         * @param filterId the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder filterId(String filterId) {
            doSetProperty("filterId", filterId);
            return this;
        }
        /**
         * Gas price used for each paid gas.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         * 
         * @param gasPrice the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder gasPrice(java.math.BigInteger gasPrice) {
            doSetProperty("gasPrice", gasPrice);
            return this;
        }
        /**
         * Gas price used for each paid gas.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         * 
         * @param gasPrice the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder gasPrice(String gasPrice) {
            doSetProperty("gasPrice", gasPrice);
            return this;
        }
        /**
         * A hexadecimal string representation (32 bytes) of the hash rate.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param hashrate the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder hashrate(String hashrate) {
            doSetProperty("hashrate", hashrate);
            return this;
        }
        /**
         * The header's pow-hash (256 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param headerPowHash the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder headerPowHash(String headerPowHash) {
            doSetProperty("headerPowHash", headerPowHash);
            return this;
        }
        /**
         * The transactions/uncle index position in the block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         * 
         * @param index the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder index(java.math.BigInteger index) {
            doSetProperty("index", index);
            return this;
        }
        /**
         * The transactions/uncle index position in the block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         * 
         * @param index the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder index(String index) {
            doSetProperty("index", index);
            return this;
        }
        /**
         * The key name in the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param keyName the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder keyName(String keyName) {
            doSetProperty("keyName", keyName);
            return this;
        }
        /**
         * The mix digest (256 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param mixDigest the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder mixDigest(String mixDigest) {
            doSetProperty("mixDigest", mixDigest);
            return this;
        }
        /**
         * The nonce found (64 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param nonce the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder nonce(String nonce) {
            doSetProperty("nonce", nonce);
            return this;
        }
        /**
         * Operation to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: transaction
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The transaction index position withing a block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         * 
         * @param position the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder position(java.math.BigInteger position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * The transaction index position withing a block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         * 
         * @param position the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder position(String position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * The priority of a whisper message.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder priority(java.math.BigInteger priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * The priority of a whisper message.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder priority(String priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * Message to sign by calculating an Ethereum specific signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param sha3HashOfDataToSign the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder sha3HashOfDataToSign(String sha3HashOfDataToSign) {
            doSetProperty("sha3HashOfDataToSign", sha3HashOfDataToSign);
            return this;
        }
        /**
         * The signed transaction data for a new message call transaction or a
         * contract creation for signed transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param signedTransactionData the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder signedTransactionData(String signedTransactionData) {
            doSetProperty("signedTransactionData", signedTransactionData);
            return this;
        }
        /**
         * The source code to compile.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param sourceCode the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder sourceCode(String sourceCode) {
            doSetProperty("sourceCode", sourceCode);
            return this;
        }
        /**
         * The information about a transaction requested by transaction hash.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param transactionHash the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder transactionHash(String transactionHash) {
            doSetProperty("transactionHash", transactionHash);
            return this;
        }
        /**
         * The time to live in seconds of a whisper message.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder ttl(java.math.BigInteger ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * The time to live in seconds of a whisper message.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder ttl(String ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * The value sent within a transaction.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder value(java.math.BigInteger value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * The value sent within a transaction.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default Web3jEndpointProducerBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Web3j Ethereum Blockchain component.
     */
    public interface AdvancedWeb3jEndpointProducerBuilder extends EndpointProducerBuilder {
        default Web3jEndpointProducerBuilder basic() {
            return (Web3jEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWeb3jEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWeb3jEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Web3j Ethereum Blockchain component.
     */
    public interface Web3jEndpointBuilder
            extends
                Web3jEndpointConsumerBuilder,
                Web3jEndpointProducerBuilder {
        default AdvancedWeb3jEndpointBuilder advanced() {
            return (AdvancedWeb3jEndpointBuilder) this;
        }

        /**
         * Contract address or a list of addresses.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder addresses(List<java.lang.String> addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * The address the transaction is send from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param fromAddress the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder fromAddress(String fromAddress) {
            doSetProperty("fromAddress", fromAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: common
         * 
         * @param fromBlock the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder fromBlock(String fromBlock) {
            doSetProperty("fromBlock", fromBlock);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param fullTransactionObjects the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder fullTransactionObjects(boolean fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param fullTransactionObjects the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder fullTransactionObjects(String fullTransactionObjects) {
            doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Group: common
         * 
         * @param gasLimit the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder gasLimit(java.math.BigInteger gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Group: common
         * 
         * @param gasLimit the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder gasLimit(String gasLimit) {
            doSetProperty("gasLimit", gasLimit);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param privateFor the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder privateFor(List<java.lang.String> privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param privateFor the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder privateFor(String privateFor) {
            doSetProperty("privateFor", privateFor);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param quorumAPI the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder quorumAPI(boolean quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * If true, this will support Quorum API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param quorumAPI the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder quorumAPI(String quorumAPI) {
            doSetProperty("quorumAPI", quorumAPI);
            return this;
        }
        /**
         * The address the transaction is directed to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param toAddress the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder toAddress(String toAddress) {
            doSetProperty("toAddress", toAddress);
            return this;
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: common
         * 
         * @param toBlock the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder toBlock(String toBlock) {
            doSetProperty("toBlock", toBlock);
            return this;
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param topics the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder topics(String topics) {
            doSetProperty("topics", topics);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option is a: <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         * 
         * @param web3j the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder web3j(org.web3j.protocol.Web3j web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
        /**
         * The preconfigured Web3j object.
         * 
         * The option will be converted to a
         * <code>org.web3j.protocol.Web3j</code> type.
         * 
         * Group: common
         * 
         * @param web3j the value to set
         * @return the dsl builder
         */
        default Web3jEndpointBuilder web3j(String web3j) {
            doSetProperty("web3j", web3j);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Web3j Ethereum Blockchain component.
     */
    public interface AdvancedWeb3jEndpointBuilder
            extends
                AdvancedWeb3jEndpointConsumerBuilder,
                AdvancedWeb3jEndpointProducerBuilder {
        default Web3jEndpointBuilder basic() {
            return (Web3jEndpointBuilder) this;
        }

    }

    public interface Web3jBuilders {
        /**
         * Web3j Ethereum Blockchain (camel-web3j)
         * Interact with Ethereum nodes using web3j client API.
         * 
         * Category: blockchain
         * Since: 2.22
         * Maven coordinates: org.apache.camel:camel-web3j
         * 
         * @return the dsl builder for the headers' name.
         */
        default Web3jHeaderNameBuilder web3j() {
            return Web3jHeaderNameBuilder.INSTANCE;
        }
        /**
         * Web3j Ethereum Blockchain (camel-web3j)
         * Interact with Ethereum nodes using web3j client API.
         * 
         * Category: blockchain
         * Since: 2.22
         * Maven coordinates: org.apache.camel:camel-web3j
         * 
         * Syntax: <code>web3j:nodeAddress</code>
         * 
         * Path parameter: nodeAddress (required)
         * Sets the node address used to communicate
         * 
         * @param path nodeAddress
         * @return the dsl builder
         */
        default Web3jEndpointBuilder web3j(String path) {
            return Web3jEndpointBuilderFactory.endpointBuilder("web3j", path);
        }
        /**
         * Web3j Ethereum Blockchain (camel-web3j)
         * Interact with Ethereum nodes using web3j client API.
         * 
         * Category: blockchain
         * Since: 2.22
         * Maven coordinates: org.apache.camel:camel-web3j
         * 
         * Syntax: <code>web3j:nodeAddress</code>
         * 
         * Path parameter: nodeAddress (required)
         * Sets the node address used to communicate
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path nodeAddress
         * @return the dsl builder
         */
        default Web3jEndpointBuilder web3j(String componentName, String path) {
            return Web3jEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Web3j Ethereum Blockchain component.
     */
    public static class Web3jHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Web3jHeaderNameBuilder INSTANCE = new Web3jHeaderNameBuilder();

        /**
         * A hexadecimal string representation (32 bytes) of the hash rate.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ETH_HASHRATE}.
         */
        public String ethHashrate() {
            return "ETH_HASHRATE";
        }
        /**
         * The id.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ID}.
         */
        public String iD() {
            return "ID";
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AT_BLOCK}.
         */
        public String atBlock() {
            return "AT_BLOCK";
        }
        /**
         * Contract address.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ADDRESS}.
         */
        public String aDDRESS() {
            return "ADDRESS";
        }
        /**
         * Contract address or a list of addresses.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ADDRESSES}.
         */
        public String aDDRESSES() {
            return "ADDRESSES";
        }
        /**
         * The address the transaction is send from.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code FROM_ADDRESS}.
         */
        public String fromAddress() {
            return "FROM_ADDRESS";
        }
        /**
         * The address the transaction is directed to.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TO_ADDRESS}.
         */
        public String toAddress() {
            return "TO_ADDRESS";
        }
        /**
         * The transaction index position withing a block.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code POSITION}.
         */
        public String pOSITION() {
            return "POSITION";
        }
        /**
         * Hash of the block where this transaction was in.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code BLOCK_HASH}.
         */
        public String blockHash() {
            return "BLOCK_HASH";
        }
        /**
         * The information about a transaction requested by transaction hash.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TRANSACTION_HASH}.
         */
        public String transactionHash() {
            return "TRANSACTION_HASH";
        }
        /**
         * Message to sign by calculating an Ethereum specific signature.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SHA3_HASH_OF_DATA_TO_SIGN}.
         */
        public String sha3HashOfDataToSign() {
            return "SHA3_HASH_OF_DATA_TO_SIGN";
        }
        /**
         * The signed transaction data for a new message call transaction or a
         * contract creation for signed transactions.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SIGNED_TRANSACTION_DATA}.
         */
        public String signedTransactionData() {
            return "SIGNED_TRANSACTION_DATA";
        }
        /**
         * If true it returns the full transaction objects, if false only the
         * hashes of the transactions.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code FULL_TRANSACTION_OBJECTS}.
         */
        public String fullTransactionObjects() {
            return "FULL_TRANSACTION_OBJECTS";
        }
        /**
         * The transactions/uncle index position in the block.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code INDEX}.
         */
        public String iNDEX() {
            return "INDEX";
        }
        /**
         * The source code to compile.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SOURCE_CODE}.
         */
        public String sourceCode() {
            return "SOURCE_CODE";
        }
        /**
         * The filter id to use.
         * 
         * The option is a: {@code java.math.BigInteger} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code FILTER_ID}.
         */
        public String filterId() {
            return "FILTER_ID";
        }
        /**
         * The local database name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DATABASE_NAME}.
         */
        public String databaseName() {
            return "DATABASE_NAME";
        }
        /**
         * The key name in the database.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code KEY_NAME}.
         */
        public String keyName() {
            return "KEY_NAME";
        }
        /**
         * The nonce found (64 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: {@code java.math.BigInteger} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code NONCE}.
         */
        public String nONCE() {
            return "NONCE";
        }
        /**
         * The header's pow-hash (256 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HEADER_POW_HASH}.
         */
        public String headerPowHash() {
            return "HEADER_POW_HASH";
        }
        /**
         * The mix digest (256 bits) used for submitting a proof-of-work
         * solution.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MIX_DIGEST}.
         */
        public String mixDigest() {
            return "MIX_DIGEST";
        }
        /**
         * A random hexadecimal(32 bytes) ID identifying the client.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code CLIENT_ID}.
         */
        public String clientId() {
            return "CLIENT_ID";
        }
        /**
         * Gas price used for each paid gas.
         * 
         * The option is a: {@code java.math.BigInteger} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GAS_PRICE}.
         */
        public String gasPrice() {
            return "GAS_PRICE";
        }
        /**
         * The maximum gas allowed in this block.
         * 
         * The option is a: {@code java.math.BigInteger} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GAS_LIMIT}.
         */
        public String gasLimit() {
            return "GAS_LIMIT";
        }
        /**
         * The value sent within a transaction.
         * 
         * The option is a: {@code java.math.BigInteger} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code VALUE}.
         */
        public String vALUE() {
            return "VALUE";
        }
        /**
         * The compiled code of a contract OR the hash of the invoked method
         * signature and encoded parameters.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DATA}.
         */
        public String dATA() {
            return "DATA";
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code FROM_BLOCK}.
         */
        public String fromBlock() {
            return "FROM_BLOCK";
        }
        /**
         * The block number, or the string latest for the last mined block or
         * pending, earliest for not yet mined transactions.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TO_BLOCK}.
         */
        public String toBlock() {
            return "TO_BLOCK";
        }
        /**
         * Topics are order-dependent. Each topic can also be a list of topics.
         * Specify multiple topics separated by comma.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TOPICS}.
         */
        public String tOPICS() {
            return "TOPICS";
        }
        /**
         * The priority of a whisper message.
         * 
         * The option is a: {@code java.math.BigInteger} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PRIORITY}.
         */
        public String pRIORITY() {
            return "PRIORITY";
        }
        /**
         * The time to live in seconds of a whisper message.
         * 
         * The option is a: {@code java.math.BigInteger} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TTL}.
         */
        public String tTL() {
            return "TTL";
        }
        /**
         * A transaction privateFor nodes with public keys in a Quorum network.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PRIVATE_FOR}.
         */
        public String privateFor() {
            return "PRIVATE_FOR";
        }
        /**
         * A transaction privateFrom.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PRIVATE_FROM}.
         */
        public String privateFrom() {
            return "PRIVATE_FROM";
        }
        /**
         * The error code.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ERROR_CODE}.
         */
        public String errorCode() {
            return "ERROR_CODE";
        }
        /**
         * The error data.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ERROR_DATA}.
         */
        public String errorData() {
            return "ERROR_DATA";
        }
        /**
         * The error message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ERROR_MESSAGE}.
         */
        public String errorMessage() {
            return "ERROR_MESSAGE";
        }
        /**
         * The status of the operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code status}.
         */
        public String status() {
            return "status";
        }
        /**
         * The operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code operation}.
         */
        public String operation() {
            return "operation";
        }
    }
    static Web3jEndpointBuilder endpointBuilder(String componentName, String path) {
        class Web3jEndpointBuilderImpl extends AbstractEndpointBuilder implements Web3jEndpointBuilder, AdvancedWeb3jEndpointBuilder {
            public Web3jEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Web3jEndpointBuilderImpl(path);
    }
}