// This file is auto-generated by @hey-api/openapi-ts

import type { CancelablePromise } from './core/CancelablePromise';
import { OpenAPI } from './core/OpenAPI';
import { request as __request } from './core/request';
import type { FetchData, FetchResponse, StateData, StateResponse, LogfilePathData, LogfilePathResponse, PushLogsData, PushLogsResponse, RegisterData, RegisterResponse, SetStateData, SetStateResponse, UpdateQueuesData, UpdateQueuesResponse, HealthResponse, WorkerData, WorkerResponse, JobsResponse, RequestWorkerMaintenanceData, RequestWorkerMaintenanceResponse, UpdateWorkerMaintenanceData, UpdateWorkerMaintenanceResponse, ExitWorkerMaintenanceData, ExitWorkerMaintenanceResponse, RequestWorkerShutdownData, RequestWorkerShutdownResponse, DeleteWorkerData, DeleteWorkerResponse, AddWorkerQueueData, AddWorkerQueueResponse, RemoveWorkerQueueData, RemoveWorkerQueueResponse } from './types.gen';

export class JobsService {
    /**
     * Fetch
     * Fetch a job to execute on the edge worker.
     * @param data The data for the request.
     * @param data.workerName
     * @param data.authorization JWT Authorization Token
     * @param data.requestBody
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static fetch(data: FetchData): CancelablePromise<FetchResponse> {
        return __request(OpenAPI, {
            method: 'POST',
            url: '/edge_worker/v1/jobs/fetch/{worker_name}',
            path: {
                worker_name: data.workerName
            },
            headers: {
                authorization: data.authorization
            },
            body: data.requestBody,
            mediaType: 'application/json',
            errors: {
                400: 'Bad Request',
                403: 'Forbidden',
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * State
     * Update the state of a job running on the edge worker.
     * @param data The data for the request.
     * @param data.dagId Identifier of the DAG to which the task belongs.
     * @param data.taskId Task name in the DAG.
     * @param data.runId Run ID of the DAG execution.
     * @param data.tryNumber The number of attempt to execute this task.
     * @param data.mapIndex For dynamically mapped tasks the mapping number, -1 if the task is not mapped.
     * @param data.state State of the assigned task under execution.
     * @param data.authorization JWT Authorization Token
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static state(data: StateData): CancelablePromise<StateResponse> {
        return __request(OpenAPI, {
            method: 'PATCH',
            url: '/edge_worker/v1/jobs/state/{dag_id}/{task_id}/{run_id}/{try_number}/{map_index}/{state}',
            path: {
                dag_id: data.dagId,
                task_id: data.taskId,
                run_id: data.runId,
                try_number: data.tryNumber,
                map_index: data.mapIndex,
                state: data.state
            },
            headers: {
                authorization: data.authorization
            },
            errors: {
                400: 'Bad Request',
                403: 'Forbidden',
                422: 'Validation Error'
            }
        });
    }
    
}

export class LogsService {
    /**
     * Logfile Path
     * Elaborate the path and filename to expect from task execution.
     * @param data The data for the request.
     * @param data.dagId Identifier of the DAG to which the task belongs.
     * @param data.taskId Task name in the DAG.
     * @param data.runId Run ID of the DAG execution.
     * @param data.tryNumber The number of attempt to execute this task.
     * @param data.mapIndex For dynamically mapped tasks the mapping number, -1 if the task is not mapped.
     * @param data.authorization JWT Authorization Token
     * @returns string Successful Response
     * @throws ApiError
     */
    public static logfilePath(data: LogfilePathData): CancelablePromise<LogfilePathResponse> {
        return __request(OpenAPI, {
            method: 'GET',
            url: '/edge_worker/v1/logs/logfile_path/{dag_id}/{task_id}/{run_id}/{try_number}/{map_index}',
            path: {
                dag_id: data.dagId,
                task_id: data.taskId,
                run_id: data.runId,
                try_number: data.tryNumber,
                map_index: data.mapIndex
            },
            headers: {
                authorization: data.authorization
            },
            errors: {
                400: 'Bad Request',
                403: 'Forbidden',
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Push Logs
     * Push an incremental log chunk from Edge Worker to central site.
     * @param data The data for the request.
     * @param data.dagId Identifier of the DAG to which the task belongs.
     * @param data.taskId Task name in the DAG.
     * @param data.runId Run ID of the DAG execution.
     * @param data.tryNumber The number of attempt to execute this task.
     * @param data.mapIndex For dynamically mapped tasks the mapping number, -1 if the task is not mapped.
     * @param data.authorization JWT Authorization Token
     * @param data.requestBody
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static pushLogs(data: PushLogsData): CancelablePromise<PushLogsResponse> {
        return __request(OpenAPI, {
            method: 'POST',
            url: '/edge_worker/v1/logs/push/{dag_id}/{task_id}/{run_id}/{try_number}/{map_index}',
            path: {
                dag_id: data.dagId,
                task_id: data.taskId,
                run_id: data.runId,
                try_number: data.tryNumber,
                map_index: data.mapIndex
            },
            headers: {
                authorization: data.authorization
            },
            body: data.requestBody,
            mediaType: 'application/json',
            errors: {
                400: 'Bad Request',
                403: 'Forbidden',
                422: 'Validation Error'
            }
        });
    }
    
}

export class WorkerService {
    /**
     * Register
     * Register a new worker to the backend.
     * @param data The data for the request.
     * @param data.workerName Hostname or instance name of the worker
     * @param data.authorization JWT Authorization Token
     * @param data.requestBody
     * @returns WorkerRegistrationReturn Successful Response
     * @throws ApiError
     */
    public static register(data: RegisterData): CancelablePromise<RegisterResponse> {
        return __request(OpenAPI, {
            method: 'POST',
            url: '/edge_worker/v1/worker/{worker_name}',
            path: {
                worker_name: data.workerName
            },
            headers: {
                authorization: data.authorization
            },
            body: data.requestBody,
            mediaType: 'application/json',
            errors: {
                400: 'Bad Request',
                403: 'Forbidden',
                409: 'Conflict',
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Set State
     * Set state of worker and returns the current assigned queues.
     * @param data The data for the request.
     * @param data.workerName Hostname or instance name of the worker
     * @param data.authorization JWT Authorization Token
     * @param data.requestBody
     * @returns WorkerSetStateReturn Successful Response
     * @throws ApiError
     */
    public static setState(data: SetStateData): CancelablePromise<SetStateResponse> {
        return __request(OpenAPI, {
            method: 'PATCH',
            url: '/edge_worker/v1/worker/{worker_name}',
            path: {
                worker_name: data.workerName
            },
            headers: {
                authorization: data.authorization
            },
            body: data.requestBody,
            mediaType: 'application/json',
            errors: {
                400: 'Bad Request',
                403: 'Forbidden',
                409: 'Conflict',
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Update Queues
     * @param data The data for the request.
     * @param data.workerName Hostname or instance name of the worker
     * @param data.authorization JWT Authorization Token
     * @param data.requestBody
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static updateQueues(data: UpdateQueuesData): CancelablePromise<UpdateQueuesResponse> {
        return __request(OpenAPI, {
            method: 'PATCH',
            url: '/edge_worker/v1/worker/queues/{worker_name}',
            path: {
                worker_name: data.workerName
            },
            headers: {
                authorization: data.authorization
            },
            body: data.requestBody,
            mediaType: 'application/json',
            errors: {
                400: 'Bad Request',
                403: 'Forbidden',
                409: 'Conflict',
                422: 'Validation Error'
            }
        });
    }
    
}

export class MonitorService {
    /**
     * Health
     * Report API Health.
     * @returns string Successful Response
     * @throws ApiError
     */
    public static health(): CancelablePromise<HealthResponse> {
        return __request(OpenAPI, {
            method: 'GET',
            url: '/edge_worker/v1/health'
        });
    }
    
}

export class UiService {
    /**
     * Worker
     * Return Edge Workers.
     * @param data The data for the request.
     * @param data.workerNamePattern
     * @param data.queueNamePattern
     * @param data.state
     * @returns WorkerCollectionResponse Successful Response
     * @throws ApiError
     */
    public static worker(data: WorkerData = {}): CancelablePromise<WorkerResponse> {
        return __request(OpenAPI, {
            method: 'GET',
            url: '/edge_worker/ui/worker',
            query: {
                worker_name_pattern: data.workerNamePattern,
                queue_name_pattern: data.queueNamePattern,
                state: data.state
            },
            errors: {
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Jobs
     * Return Edge Jobs.
     * @returns JobCollectionResponse Successful Response
     * @throws ApiError
     */
    public static jobs(): CancelablePromise<JobsResponse> {
        return __request(OpenAPI, {
            method: 'GET',
            url: '/edge_worker/ui/jobs'
        });
    }
    
    /**
     * Request Worker Maintenance
     * Put a worker into maintenance mode.
     * @param data The data for the request.
     * @param data.workerName
     * @param data.requestBody
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static requestWorkerMaintenance(data: RequestWorkerMaintenanceData): CancelablePromise<RequestWorkerMaintenanceResponse> {
        return __request(OpenAPI, {
            method: 'POST',
            url: '/edge_worker/ui/worker/{worker_name}/maintenance',
            path: {
                worker_name: data.workerName
            },
            body: data.requestBody,
            mediaType: 'application/json',
            errors: {
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Update Worker Maintenance
     * Update maintenance comments for a worker.
     * @param data The data for the request.
     * @param data.workerName
     * @param data.requestBody
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static updateWorkerMaintenance(data: UpdateWorkerMaintenanceData): CancelablePromise<UpdateWorkerMaintenanceResponse> {
        return __request(OpenAPI, {
            method: 'PATCH',
            url: '/edge_worker/ui/worker/{worker_name}/maintenance',
            path: {
                worker_name: data.workerName
            },
            body: data.requestBody,
            mediaType: 'application/json',
            errors: {
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Exit Worker Maintenance
     * Exit a worker from maintenance mode.
     * @param data The data for the request.
     * @param data.workerName
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static exitWorkerMaintenance(data: ExitWorkerMaintenanceData): CancelablePromise<ExitWorkerMaintenanceResponse> {
        return __request(OpenAPI, {
            method: 'DELETE',
            url: '/edge_worker/ui/worker/{worker_name}/maintenance',
            path: {
                worker_name: data.workerName
            },
            errors: {
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Request Worker Shutdown
     * Request shutdown of a worker.
     * @param data The data for the request.
     * @param data.workerName
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static requestWorkerShutdown(data: RequestWorkerShutdownData): CancelablePromise<RequestWorkerShutdownResponse> {
        return __request(OpenAPI, {
            method: 'POST',
            url: '/edge_worker/ui/worker/{worker_name}/shutdown',
            path: {
                worker_name: data.workerName
            },
            errors: {
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Delete Worker
     * Delete a worker record from the system.
     * @param data The data for the request.
     * @param data.workerName
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static deleteWorker(data: DeleteWorkerData): CancelablePromise<DeleteWorkerResponse> {
        return __request(OpenAPI, {
            method: 'DELETE',
            url: '/edge_worker/ui/worker/{worker_name}',
            path: {
                worker_name: data.workerName
            },
            errors: {
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Add Worker Queue
     * Add a queue to a worker.
     * @param data The data for the request.
     * @param data.workerName
     * @param data.queueName
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static addWorkerQueue(data: AddWorkerQueueData): CancelablePromise<AddWorkerQueueResponse> {
        return __request(OpenAPI, {
            method: 'PUT',
            url: '/edge_worker/ui/worker/{worker_name}/queues/{queue_name}',
            path: {
                worker_name: data.workerName,
                queue_name: data.queueName
            },
            errors: {
                422: 'Validation Error'
            }
        });
    }
    
    /**
     * Remove Worker Queue
     * Remove a queue from a worker.
     * @param data The data for the request.
     * @param data.workerName
     * @param data.queueName
     * @returns unknown Successful Response
     * @throws ApiError
     */
    public static removeWorkerQueue(data: RemoveWorkerQueueData): CancelablePromise<RemoveWorkerQueueResponse> {
        return __request(OpenAPI, {
            method: 'DELETE',
            url: '/edge_worker/ui/worker/{worker_name}/queues/{queue_name}',
            path: {
                worker_name: data.workerName,
                queue_name: data.queueName
            },
            errors: {
                422: 'Validation Error'
            }
        });
    }
    
}