/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.net.URI;
import java.util.List;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.provider.ProviderSynchronization;

public interface Provider {
    public void connect(JmsConnectionInfo var1) throws ProviderException;

    public void start() throws ProviderException, IllegalStateException;

    public void close();

    public URI getRemoteURI();

    public List<URI> getAlternateURIs();

    public void create(JmsResource var1, AsyncResult var2) throws ProviderException;

    public void start(JmsResource var1, AsyncResult var2) throws ProviderException;

    public void stop(JmsResource var1, AsyncResult var2) throws ProviderException;

    public void destroy(JmsResource var1, AsyncResult var2) throws ProviderException;

    public void send(JmsOutboundMessageDispatch var1, AsyncResult var2) throws ProviderException;

    public void acknowledge(JmsSessionId var1, ProviderConstants.ACK_TYPE var2, AsyncResult var3) throws ProviderException;

    public void acknowledge(JmsInboundMessageDispatch var1, ProviderConstants.ACK_TYPE var2, AsyncResult var3) throws ProviderException;

    public void commit(JmsTransactionInfo var1, JmsTransactionInfo var2, AsyncResult var3) throws ProviderException;

    public void rollback(JmsTransactionInfo var1, JmsTransactionInfo var2, AsyncResult var3) throws ProviderException;

    public void recover(JmsSessionId var1, AsyncResult var2) throws ProviderException;

    public void unsubscribe(String var1, AsyncResult var2) throws ProviderException;

    public void pull(JmsConsumerId var1, long var2, AsyncResult var4) throws ProviderException;

    public JmsMessageFactory getMessageFactory();

    public ProviderFuture newProviderFuture();

    public ProviderFuture newProviderFuture(ProviderSynchronization var1);

    public void setProviderListener(ProviderListener var1);

    public ProviderListener getProviderListener();
}

