/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton.transaction;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionRefsOperation;
import org.apache.qpid.proton.engine.Delivery;

public class ProtonTransactionImpl
extends TransactionImpl {
    final Map<MessageReference, Pair<Delivery, ProtonServerSenderContext>> deliveries = new HashMap<MessageReference, Pair<Delivery, ProtonServerSenderContext>>();
    private boolean discharged;

    public ProtonTransactionImpl(Xid xid, StorageManager storageManager, int timeoutSeconds, AMQPConnectionContext connection) {
        super(xid, storageManager, timeoutSeconds);
        this.addOperation((TransactionOperation)new TXOperations(connection, this));
    }

    public RefsOperation createRefsOperation(Queue queue, AckReason reason) {
        return new ProtonTransactionRefsOperation(queue, reason, this.storageManager);
    }

    public void rollback() throws Exception {
        super.rollback();
    }

    public void addDelivery(Delivery delivery, ProtonServerSenderContext context) {
        this.deliveries.put((MessageReference)delivery.getContext(), (Pair<Delivery, ProtonServerSenderContext>)new Pair((Object)delivery, (Object)context));
    }

    public Map<MessageReference, Pair<Delivery, ProtonServerSenderContext>> getDeliveries() {
        return this.deliveries;
    }

    public void commit() throws Exception {
        super.commit();
    }

    public boolean isDischarged() {
        return this.discharged;
    }

    public void discharge() {
        this.discharged = true;
    }

    private static class TXOperations
    extends TransactionOperationAbstract {
        final ProtonTransactionImpl protonTransaction;
        final AMQPConnectionContext connection;

        TXOperations(AMQPConnectionContext connection, ProtonTransactionImpl tx) {
            this.protonTransaction = tx;
            this.connection = connection;
        }

        public void afterCommit(Transaction tx) {
            super.afterCommit(tx);
            this.connection.runNow(() -> {
                for (Pair<Delivery, ProtonServerSenderContext> p : this.protonTransaction.deliveries.values()) {
                    if (((Delivery)p.getA()).isSettled()) continue;
                    ((ProtonServerSenderContext)p.getB()).settle((Delivery)p.getA());
                }
                this.connection.flush();
                this.protonTransaction.deliveries.forEach((a, b) -> ((Delivery)b.getA()).setContext(null));
                this.protonTransaction.deliveries.clear();
            });
        }
    }
}

