% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksvF0.R
\name{ksvF0}
\alias{ksvF0}
\alias{f0ana}
\alias{f0_ksv}
\title{ksvF0}
\usage{
ksvF0(
  listOfFiles = NULL,
  optLogFilePath = NULL,
  beginTime = 0,
  endTime = 0,
  windowShift = 5,
  gender = "u",
  maxF = 600,
  minF = 50,
  minAmp = 50,
  maxZCR = 3000,
  toFile = TRUE,
  explicitExt = NULL,
  outputDirectory = NULL,
  forceToLog = useWrasspLogger,
  verbose = TRUE
)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>: set begin of analysis interval to <time> seconds (default = 0: begin of data)}

\item{endTime}{set end of analysis interval to <time> seconds (default = 0: end of data)}

\item{windowShift}{= <dur>: set frame shift to <dur> ms (default: 5.0)}

\item{gender}{= <code>  set gender-specific F0 ranges; <code> may be:
"f[emale]" (80.0 - 640.0 Hz)
"m[ale]" (50.0 - 400.0 Hz)
"u[nknown]" (default; 50.0 - 600.0 Hz)}

\item{maxF}{= <freq>: set maximum F0 value to <freq> Hz (default: 500.0)}

\item{minF}{= <freq>: set minimum F0 value to <freq> Hz (default: 50.0)}

\item{minAmp}{= <amp>: set amplitude threshold for voiced samples to <amp> (default: 100)}

\item{maxZCR}{maximum zero crossing rate in Hz (for voicing detection)}

\item{toFile}{write results to file (default extension is .f0)}

\item{explicitExt}{set if you wish to override the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e.
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}

\item{verbose}{display infos & show progress bar}
}
\value{
nrOfProcessedFiles or if only one file to process return AsspDataObj of that file
}
\description{
ksvF0 function adapted from libassp
}
\details{
F0 analysis of the signal in <listOfFiles> using the 
K. Schaefer-Vincent periodicity detection algorithm.
Analysis results will be written to a file with the
base name of the input file and extension '.f0'.
Default output is in SSFF binary format (track 'F0').
Optionally, location and type of the signal extrema on
which the F0 data are based, may be stored in a label
file. The name of this file will consist of the base
name of the F0 file and the extension '.prd'.
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"), 
                       pattern = glob2rx("*.wav"), 
                       full.names = TRUE)[1]

# calculate fundamental frequency contour
res <- ksvF0(path2wav, toFile=FALSE)

# plot the fundamental frequency contour
plot(seq(0,numRecs.AsspDataObj(res) - 1) / rate.AsspDataObj(res) +
       attr(res, 'startTime'),
     res$F0, 
     type='l', 
     xlab='time (s)', 
     ylab='F0 frequency (Hz)')
     
}
\references{
Schaefer-Vincent K (1983) Pitch period detection and chaining: method and evaluation. Phonetica 1983, Vol 40, pp. 177-202
}
\seealso{
\code{\link{mhsF0}} for an alternative pitch tracker
}
\author{
Raphael Winkelmann

Lasse Bombien
}
