% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_models.R
\name{fit_twoway_fe}
\alias{fit_twoway_fe}
\title{Fit Two-Way Fixed Effects Panel Model}
\usage{
fit_twoway_fe(
  panel_data,
  robust_se = TRUE,
  cluster_type = c("group", "time", "twoway")
)
}
\arguments{
\item{panel_data}{Data frame in panel format with columns: year, sector,
log_direct, log_production.}

\item{robust_se}{Logical. Compute robust standard errors. Default TRUE.}

\item{cluster_type}{Character. Type of cluster for robust SE.
One of "group", "time", or "twoway". Default "group".}
}
\value{
A list containing:
\describe{
  \item{model}{The fitted plm model object}
  \item{summary}{Model summary}
  \item{r2_within}{Within R-squared}
  \item{coeftest_robust}{Coefficient test with robust SE (if robust_se=TRUE)}
  \item{metrics}{In-sample evaluation metrics}
}
}
\description{
Fits a two-way fixed effects model with sector and time effects,
regressing log production prices on log direct prices.
}
\details{
This function requires the 'plm' package. The model specification is:
log_production ~ log_direct with two-way (sector and time) fixed effects.
}
\examples{
\donttest{
if (requireNamespace("plm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2009, 5),
    sector = rep(LETTERS[1:5], each = 10),
    log_direct = rnorm(50, 5, 0.5),
    log_production = rnorm(50, 5, 0.5)
  )
  panel$log_production <- panel$log_direct * 0.95 + rnorm(50, 0, 0.1)

  result <- fit_twoway_fe(panel)
  print(result$r2_within)
}
}

}
