% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{subset_known_mf}
\alias{subset_known_mf}
\title{Subsetting known molecular formula categories}
\usage{
subset_known_mf(
  mfd,
  select_category = NULL,
  exclude_category = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{select_category}{List of category names that should be selected}

\item{exclude_category}{List of category names that should be ignored}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments passed to methods.}
}
\value{
data.table; subset of original molecular formula data.table (mfd)
}
\description{
Subset all molecular formulas that are present in one or more
categories of ume::known_mf. Based on presence / absence.
}
\examples{
subset_known_mf(category_list = c("marine_dom"), mfd = mf_data_demo, verbose = TRUE)
}
\seealso{
Other Formula subsetting: 
\code{\link{filter_int}()},
\code{\link{filter_mass_accuracy}()},
\code{\link{filter_mf_data}()},
\code{\link{remove_blanks}()},
\code{\link{ume_assign_formulas}()},
\code{\link{ume_filter_formulas}()}
}
\concept{Formula subsetting}
\keyword{misc}
