% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_objects.R
\name{check_formula_library}
\alias{check_formula_library}
\title{Check format of formula library}
\usage{
check_formula_library(formula_library, ...)
}
\arguments{
\item{formula_library}{Molecular formula library: a predefined data.table used for
assigning molecular formulas to a peak list and for mass calibration. The library
requires a fixed format, including mass values for matching. Predefined libraries
are available in the R package \emph{ume.formulas} and further described in
Leefmann et al. (2019). A standard library for marine dissolved organic matter is
\code{ume.formulas::lib_02}. New libraries can be built using
\code{ume::create_ume_formula_library()}.}

\item{...}{Additional arguments passed to methods.}
}
\value{
data.table
}
\description{
Verify the correct usage of UME column names, existence of a unique peak identifier (peak_id),
and a unique file/analysis name (file_id).
Remove rows having missing values for either m/z (mz) or peak magnitude (i_magnitude).
}
\references{
Leefmann, T., Frickenhaus, S., Koch, B.P., 2019. UltraMassExplorer: a browser-based application
for the evaluation of high-resolution mass spectrometric data. Rapid Communications in Mass Spectrometry 33, 193-202.
}
\seealso{
Other Formula assignment: 
\code{\link{add_known_mf}()},
\code{\link{calc_eval_params}()},
\code{\link{eval_isotopes}()},
\code{\link{ume_assign_formulas}()}

Other check ume objects: 
\code{\link{as_peaklist}()},
\code{\link{check_mfd}()}
}
\author{
Boris P. Koch
}
\concept{Formula assignment}
\concept{check ume objects}
\keyword{internal}
