% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_histogram.R
\name{type_histogram}
\alias{type_histogram}
\alias{type_hist}
\title{Histogram plot type}
\usage{
type_histogram(
  breaks = "Sturges",
  freq = NULL,
  right = TRUE,
  free.breaks = FALSE,
  drop.zeros = TRUE
)

type_hist(
  breaks = "Sturges",
  freq = NULL,
  right = TRUE,
  free.breaks = FALSE,
  drop.zeros = TRUE
)
}
\arguments{
\item{breaks}{Passed to \code{\link[graphics]{hist}}. One of:
\itemize{
\item a vector giving the breakpoints between histogram cells,
\item a function to compute the vector of breakpoints,
\item a single number giving the number of cells for the histogram,
\item a character string naming an algorithm to compute the number of cells (see ‘Details’ of \code{\link[graphics]{hist}}),
\item a function to compute the number of cells.
In the last three cases the number is a suggestion only; as the breakpoints
will be set to pretty values, the number is limited to 1e6 (with a warning if
it was larger). If breaks is a function, the x vector is supplied to it as
the only argument (and the number of breaks is only limited by the amount of
available memory).
}}

\item{freq}{logical; if \code{TRUE}, the histogram graphic is a
    representation of frequencies, the \code{counts} component of
    the result; if \code{FALSE}, probability densities, component
    \code{density}, are plotted (so that the histogram has a total area
    of one).  Defaults to \code{TRUE} \emph{if and only if} \code{breaks} are
    equidistant (and \code{probability} is not specified).}

\item{right}{logical; if \code{TRUE}, the histogram cells are
    right-closed (left open) intervals.}

\item{free.breaks}{Logical indicating whether the breakpoints should be
computed separately for each group or facet? Default is \code{FALSE}, meaning
that the breakpoints are computed from the full dataset; thus ensuring
common bin widths across each group/facet. Can also use \code{free} as an
acceptable argument alias. Ignored if there are no groups and/or facets.}

\item{drop.zeros}{Logical indicating whether bins with zero counts should be
dropped before plotting. Default is \code{TRUE}. Note that switching to \code{FALSE}
may interfere with faceted plot behaviour if \code{facet.args = list(free)},
since the \code{x} variable is effectively recorded over the full range of the
x-axis (even if it does not extend over this range for every group).}
}
\description{
Type function for histogram plots. \code{type_hist} is an alias for
\code{type_histogram}.
}
\examples{
# "histogram"/"hist" type convenience string(s)
tinyplot(Nile, type = "histogram")

# Use `type_histogram()` to pass extra arguments for customization
tinyplot(Nile, type = type_histogram(breaks = 30))
tinyplot(Nile, type = type_histogram(breaks = 30, freq = FALSE))
# etc.

# Grouped histogram example
tinyplot(
    ~ Petal.Width | Species,
    type = "histogram",
    data = iris
)

# Faceted version
tinyplot(
    ~Petal.Width,
    facet = ~Species,
    type = "histogram",
    data = iris
)

# For visualizing faceted histograms across varying scales, you may also wish
# to impose free histogram breaks too (i.e., calculate breaks separately for
# each group). Compare:

# free facet scales + shared histogram breaks, versus...
tinyplot(
    ~Petal.Width,
    facet = ~Species,
    facet.args = list(free = TRUE),
    type = type_histogram(),
    data = iris
)
# ... free facet scales + free histogram breaks
tinyplot(
    ~Petal.Width,
    facet = ~Species,
    facet.args = list(free = TRUE),
    type = type_histogram(free = TRUE),
    data = iris
)

}
